###################################################
### chunk number 1: 
###################################################
library(nsRFA)


###################################################
### chunk number 2: 
###################################################
data(hydroSIMN)


###################################################
### chunk number 3:  eval=FALSE
###################################################
## ls()
## help(hydroSIMN)


###################################################
### chunk number 4: 
###################################################
Dm <- parameters[,"Dm"]
logDm <- log(Dm)
sqrtDm <- sqrt(Dm)
sqrt3Dm <- Dm^(1/3)


###################################################
### chunk number 5: 
###################################################
attributes <- parameters[,-c(1,2)]
logattributes <- log(attributes[,-c(7:9)])
mixedattributes <- cbind(attributes, logattributes[,1])
 names(mixedattributes) <- c(names(attributes), "lnAm")


###################################################
### chunk number 6: nontrasfregr
###################################################
nontrasfregr <- bestlm(Dm, mixedattributes, kmax=3, nbest=4); nontrasfregr


###################################################
### chunk number 7: 
###################################################
nregr <- dim(nontrasfregr$subselect)[1]
diagn <- data.frame(matrix(NA, nrow=nregr, ncol=2)); names(diagn) <- c("RMSE","RMSEjk")
for (i in 1:nregr){
 f <- paste("Dm ~", paste(colnames(nontrasfregr$subselect)[nontrasfregr$subselect[i,]], collapse=" + "))
 regr <- lm(f, mixedattributes)
 diagn[i,1] <- RMSE.lm(regr)
 diagn[i,2] <- RMSEjk.lm(regr)
}
diagn


###################################################
### chunk number 8: multregr
###################################################
multregr <- bestlm(logDm, logattributes, kmax=3, nbest=4); multregr


###################################################
### chunk number 9: 
###################################################
nregr <- dim(multregr$subselect)[1]
diagn <- data.frame(matrix(NA, nrow=nregr, ncol=2)); names(diagn) <- c("RMSE","RMSEjk")
for (i in 1:nregr){
 f <- paste("logDm ~", paste(colnames(multregr$subselect)[multregr$subselect[i,]], collapse=" + "))
 regr <- lm(f, logattributes)
 fitt <- regr$fitted.values
 crossval <- jackknife1.lm(regr)
 diagn[i,1] <- RMSE(Dm, exp(fitt))
 diagn[i,2] <- RMSE(Dm, exp(crossval))
}
diagn


###################################################
### chunk number 10: trasfregr_log
###################################################
trasfregr_log <- bestlm(logDm, mixedattributes, kmax=3, nbest=4); trasfregr_log


###################################################
### chunk number 11: 
###################################################
nregr <- dim(trasfregr_log$subselect)[1]
diagn <- data.frame(matrix(NA, nrow=nregr, ncol=2)); names(diagn) <- c("RMSE","RMSEjk")
for (i in 1:nregr){
 f <- paste("logDm ~", paste(colnames(trasfregr_log$subselect)[trasfregr_log$subselect[i,]], collapse=" + "))
 regr <- lm(f, mixedattributes)
 fitt <- regr$fitted.values
 crossval <- jackknife1.lm(regr)
 diagn[i,1] <- RMSE(Dm, exp(fitt))
 diagn[i,2] <- RMSE(Dm, exp(crossval))
}
diagn


###################################################
### chunk number 12: trasfregr_sqrt
###################################################
trasfregr_sqrt <- bestlm(sqrtDm, mixedattributes, kmax=3, nbest=4); trasfregr_sqrt


###################################################
### chunk number 13: 
###################################################
nregr <- dim(trasfregr_sqrt$subselect)[1]
diagn <- data.frame(matrix(NA, nrow=nregr, ncol=2)); names(diagn) <- c("RMSE","RMSEjk")
for (i in 1:nregr){
 f <- paste("sqrtDm ~", paste(colnames(trasfregr_sqrt$subselect)[trasfregr_sqrt$subselect[i,]], collapse=" + "))
 regr <- lm(f, mixedattributes)
 fitt <- regr$fitted.values
 crossval <- jackknife1.lm(regr)
 diagn[i,1] <- RMSE(Dm, fitt^2)
 diagn[i,2] <- RMSE(Dm, crossval^2)
}
diagn


###################################################
### chunk number 14: trasfregr_sqrt3
###################################################
trasfregr_sqrt3 <- bestlm(sqrt3Dm, mixedattributes, kmax=3, nbest=4); trasfregr_sqrt3


###################################################
### chunk number 15: 
###################################################
nregr <- dim(trasfregr_sqrt3$subselect)[1]
diagn <- data.frame(matrix(NA, nrow=nregr, ncol=2)); names(diagn) <- c("RMSE","RMSEjk")
for (i in 1:nregr){
 f <- paste("sqrt3Dm ~", paste(colnames(trasfregr_sqrt3$subselect)[trasfregr_sqrt3$subselect[i,]], collapse=" + "))
 regr <- lm(f, mixedattributes)
 fitt <- regr$fitted.values
 crossval <- jackknife1.lm(regr)
 diagn[i,1] <- RMSE(Dm, fitt^3)
 diagn[i,2] <- RMSE(Dm, crossval^3)
}
diagn


###################################################
### chunk number 16: 
###################################################
bestregr <- lm(sqrt3Dm ~ S2000 + IT + lnAm, mixedattributes); bestregr


###################################################
### chunk number 17: 
###################################################
summary(bestregr)


###################################################
### chunk number 18: 
###################################################
vif.lm(bestregr)
cor(bestregr$model[-1])


###################################################
### chunk number 19: 
###################################################
prt.lm(bestregr)


###################################################
### chunk number 20: bestregression
###################################################
bestregr <- lm(logDm ~ Hm + NORD + IB, mixedattributes)
bestregr
summary(bestregr)


###################################################
### chunk number 21: 
###################################################
prt.lm(bestregr)


###################################################
### chunk number 22: 
###################################################
vif.lm(bestregr)
cor(bestregr$model[-1])


###################################################
### chunk number 23: 
###################################################
p_norm <- A2_GOFlaio(bestregr$residuals, dist="NORM"); p_norm


###################################################
### chunk number 24: 
###################################################
rmse <- RMSE(Dm, exp(bestregr$fitted.values))

predicted <- jackknife1.lm(bestregr)
rmse_jk <- RMSE(Dm, exp(predicted))


###################################################
### chunk number 25: 
###################################################
op <- par(mfrow=c(2,2))
 plot(bestregr$fitted.values, bestregr$residuals, xlab="Fitted", ylab="Residuals")
  abline(0,0,lty=3)

 normplot(bestregr$residuals, xlab="Residuals")
 
 plot(parameters[,c("Dm")], exp(bestregr$fitted.values), xlab="Originals", ylab="Fitted")
  abline(0,1,lty=3)
  intervals <- predinterval.lm(bestregr)
  intervals <- intervals[order(intervals[,1]),]
 
 plot(parameters[,c("Dm")], exp(predicted), xlab="Originals", ylab="Predicted")
  abline(0,1,lty=3)
  lines(exp(intervals[,c(1,2)]),lty=2)
  lines(exp(intervals[,c(1,3)]),lty=2)
par(op)


###################################################
### chunk number 26: 
###################################################
D <- annualflows["dato"][,]
y <- annualflows["anno"][,]
cod <- annualflows["cod"][,]


###################################################
### chunk number 27: 
###################################################
consistencyplot(y,cod)


###################################################
### chunk number 28: 
###################################################
ni <- tapply(D, cod, length)
annualflows15 <- annualflows[unsplit(ni, cod)>=15,]
parameters15 <- parameters[ni>=15,]
D15 <- annualflows15["dato"][,]
cod15 <- annualflows15["cod"][,]


###################################################
### chunk number 29: 
###################################################
LM15 <- data.frame(t(sapply(split(D15, cod15), Lmoments)))


###################################################
### chunk number 30: 
###################################################
plot(LM15[3:5])


###################################################
### chunk number 31: 
###################################################
Lspace.HWvsAD()
points(LM15[,4:3])


###################################################
### chunk number 32: 
###################################################
set.seed(10)


###################################################
### chunk number 33: 
###################################################
D15adim <- D15/unsplit(tapply(D15, cod15, mean), cod15)
HWs <- HW.tests(D15adim, cod15)[1]; HWs


###################################################
### chunk number 34: 
###################################################
bestlm(LM15[,"lcv"], parameters15[,3:16], kmax=3)


###################################################
### chunk number 35: 
###################################################
bestlm(as.numeric(AD.dist(D15,cod15)), data.frame(apply(parameters15[,3:16], 2, dist)), kmax=3)


###################################################
### chunk number 36: mantel.test
###################################################
Y <- AD.dist(D15,cod15)
X <- data.frame(apply(parameters15[,c("Hm","Ybar")],2,dist))
datamantel <- cbind(as.numeric(Y),X)
regrmantel <- lm(Y ~ Hm + Ybar, datamantel)
#summary(regrmantel)
mantel.lm(regrmantel, Nperm=100)


###################################################
### chunk number 37: clusteranalysis
###################################################
param <- parameters15[c("Hm","Ybar")]
n <- dim(param)[1]; k <- dim(param)[2]
param.norm <- (param - matrix(mean(param), nrow=n, ncol=k, byrow=TRUE))/matrix(sd(param), nrow=n, ncol=k, byrow=TRUE)


###################################################
### chunk number 38: 
###################################################
set.seed(10)


###################################################
### chunk number 39: 
###################################################
nclusters=1
while (max(HWs) > 2.1) {
 nclusters <- nclusters+1
 clusters <- traceWminim(param.norm, nclusters)
 indclusters <- unsplit(clusters, cod15)
 HWs <- rep(NA, nclusters)
 for (i in unique(clusters)) {
  HWs[i] <- HW.tests(D15adim[indclusters==i], cod15[indclusters==i])[1]
 }
 print(HWs)
} 


###################################################
### chunk number 40: 
###################################################
regLM15 <- t(sapply(split(D15adim, indclusters), Lmoments))[,3:5]
regLM15


###################################################
### chunk number 41: 
###################################################
for (i in 1:nclusters) {
 print(regionalLmoments(D15adim[indclusters==i], cod15[indclusters==i])[3:5])
}


###################################################
### chunk number 42: 
###################################################
op <- par(mfrow=c(2,2))
 plot(parameters15[c("Hm","Ybar")], col=clusters, pch=clusters, cex=0.6,
      main="Clusters in the space of classification variables", cex.main=1, font.main=1)
  grid()
  points(tapply(parameters15["Hm"][,], clusters, mean), tapply(parameters15["Ybar"][,], clusters, mean),
         col=c(1:nclusters), pch=c(1:nclusters))
 legend("topleft",paste("clust ",c(1:nclusters)), col=c(1:nclusters), pch=c(1:nclusters), bty="n")

 plot(parameters15[c("Xbar","Ybar")], col=clusters, pch=clusters, cex=0.6,
      main="Clusters in geographical space", cex.main=1, font.main=1)
  grid()

 plot(LM15[,4:3], pch=clusters, col=clusters, cex=0.6,
      main="Clusters in L-moments space", cex.main=1, font.main=1)
  points(regLM15[,2:1], col=c(1:nclusters), pch=c(1:nclusters))
  grid()

 plot(LM15[,4:5], pch=clusters, col=clusters, cex=0.6,
      main="Clusters in L-moments space", cex.main=1, font.main=1)
  points(regLM15[,2:3], col=c(1:nclusters), pch=c(1:nclusters))
  grid()
par(op)


###################################################
### chunk number 43: 
###################################################
Lmoment.ratio.diagram()
 points(regLM15[,2:3], col=c(1:nclusters), pch=c(1:nclusters))
 legend("bottomleft",paste("clust ", c(1:nclusters)), col=c(1:nclusters), pch=c(1:nclusters), bty="n")


###################################################
### chunk number 44: GOFlaio2004
###################################################
for (i in 1:nclusters) {
  GOFA2_P3 <- A2_GOFlaio(D15adim[indclusters==i], dist="P3")
  cat(paste("\np(A2) for Cluster ", i, ":\n", sep=""))
  print(GOFA2_P3)
}


###################################################
### chunk number 45: 
###################################################
paramgamma=NULL
for (i in 1:nclusters) {
 paramgamma[[i]] <- par.gamma(1, regLM15[i,1], regLM15[i,2])
 cat(paste("\nCluster",i,":\n"))
 print(format(paramgamma[[i]][1:3]))
}


###################################################
### chunk number 46: 
###################################################
for (i in 1:nclusters) {
 cat(paste("\nCluster",i,":\n"))
 print(format(par2mom.gamma(paramgamma[[i]]$xi, paramgamma[[i]]$beta, paramgamma[[i]]$alfa)))
}


###################################################
### chunk number 47: GrowthCurves1.png
###################################################
png(file="GrowthCurves1.png", height=960, width=960, res=144, pointsize=9)


###################################################
### chunk number 48: 
###################################################
op <- par(mfrow=c(2,2))
 for (i in 1:nclusters) {
  FF <- F.gamma(D15adim[indclusters==i], paramgamma[[i]]$xi, paramgamma[[i]]$beta, paramgamma[[i]]$alfa)
  regionalplotpos(D15adim[indclusters==i], cod15[indclusters==i], xlab=paste("cluster", i),
                  main="Empirical distributions", cex.main=1, font.main=1)
  lines(sort(D15adim[indclusters==i]), sort(FF))
  nomi <- names(clusters)[clusters==i]
  legend("bottomright", legend=nomi, pch=c(1:length(nomi)), col=c(1:length(nomi)), bty="n", cex=.9)
 }
par(op)


###################################################
### chunk number 49: 
###################################################
dev.off()


###################################################
### chunk number 50: GrowthCurves2.png
###################################################
png(file="GrowthCurves2.png", height=960, width=960, res=144, pointsize=9)


###################################################
### chunk number 51: 
###################################################
op <- par(mfrow=c(2,2))
 for (i in 1:nclusters) {
  Fs <- seq(0.001,0.999,by=.001)
  regionalnormplot(D15adim[indclusters==i], cod15[indclusters==i], xlab=paste("cluster", i),
                  main="Empirical distributions", cex.main=1, font.main=1)
  normpoints(invF.gamma(Fs, paramgamma[[i]]$xi, paramgamma[[i]]$beta, paramgamma[[i]]$alfa), type="l")
  nomi <- names(clusters)[clusters==i]
  legend("bottomright", legend=nomi, pch=c(1:length(nomi)), col=c(1:length(nomi)), bty="n", cex=.9)
 }
par(op)


###################################################
### chunk number 52: 
###################################################
dev.off()


###################################################
### chunk number 53: 
###################################################
spess=c(1, 1.5, 2, 1.3)
Fs <- seq(0.001,0.999,by=.001)
lognormplot(D15adim, line=FALSE, type="n", )
for (i in 1:nclusters) {
 qq <- invF.gamma(Fs, paramgamma[[i]]$xi, paramgamma[[i]]$beta, paramgamma[[i]]$alfa)
 normpoints(qq, type="l", lty=i, col=i, lwd=spess[i])
}
legend("bottomright", paste("cluster ", c(1:nclusters)), col=c(1:nclusters), lty=c(1:nclusters), lwd=spess, bty="n")


