### Name: colldiag
### Title: Condition indexes and variance decomposition proportions
### Aliases: colldiag print.colldiag
### Keywords: regression

### ** Examples

# Belsley (1991). "Conditioning Diagnostics"
# The Consumption Function (pp. 149-154)
data(consumption)

ct1<-c(NA,c[-length(c)])

# compare (5.3)
m1<-lm(c~ct1+dpi+r+d_dpi)
anova(m1)
summary(m1)

# compare exhibit 5.11
cor(cbind(ct1,dpi,r,d_dpi),use="complete.obs")

# compare exhibit 5.12
cd<-colldiag(m1)
cd
print(cd,fuzz=.3)



