### Name: slice.design
### Title: Design matrices for likelihood slices and profiles
### Aliases: slice.design profile.design
### Keywords: design

### ** Examples

## A single 11-point slice through the point c(A=3,B=8,C=0) along the B direction.
x <- slice.design(list(A=3,B=c(0,8,10),C=0),n=11)
dim(x)
plot(x)
## Two slices through the same point along the A and C directions.
x <- slice.design(list(A=c(0,3,5),B=8,C=c(0,0,5)),n=11)
dim(x)
plot(x)

## A one-parameter profile design:
x <- profile.design(p=1:10,vars=list(a=c(0,1),b=c(0,5)),n=20)
dim(x)
plot(x)
## A two-parameter profile design:
x <- profile.design(p=1:10,q=3:5,vars=list(a=c(0,1),b=c(0,5)),n=20)
dim(x)
plot(x)



