### Name: traj.match
### Title: Trajectory matching
### Aliases: traj.match
### Keywords: models ts

### ** Examples

  data(ou2)
  true.p <- c(
              alpha.1=0.9,alpha.2=0,alpha.3=0,alpha.4=0.99,
              sigma.1=1,sigma.2=0,sigma.3=2,
              tau=1,
              x1.0=50,x2.0=-50
              )
  simdata <- simulate(ou2,nsim=1,params=true.p,seed=43553)
  guess.p <- true.p
  guess.p[grep('sigma',names(guess.p))] <- 0 ## make the process model deterministic
  res <- traj.match(
                    simdata,
                    start=guess.p,
                    est=c('alpha.1','alpha.4','x1.0','x2.0','tau'),
                    maxit=2000,
                    reltol=1e-8
                    )



