###################################################
### chunk number 1: 
###################################################
  glop <- options(keep.source=TRUE,width=60,continue=" ",prompt=" ")
  library(pomp)
  pdf.options(useDingbats=FALSE)
  set.seed(5384959)


###################################################
### chunk number 2: 
###################################################
data(ou2)
true.p <- coef(ou2)
x0 <- init.state(ou2)
x0
new.p <- cbind(true.p,true.p,true.p)
new.p["x1.0",] <- 1:3
init.state(ou2,params=new.p)


###################################################
### chunk number 3: 
###################################################
x <- rprocess(ou2,xstart=x0,times=time(ou2,t0=T),params=as.matrix(true.p))
dim(x)
x[,,1:5]


###################################################
### chunk number 4: 
###################################################
x <- x[,,-1,drop=F]
y <- rmeasure(ou2,x=x,times=time(ou2),params=as.matrix(true.p))
dim(y)
y[,,1:5]


###################################################
### chunk number 5: 
###################################################
fp <- dprocess(ou2,x=x,times=time(ou2),params=as.matrix(true.p))
dim(fp)
fp[,36:40]


###################################################
### chunk number 6: 
###################################################
fm <- dmeasure(ou2,y=y[,1,],x=x,times=time(ou2),params=as.matrix(true.p))
dim(fm)
fm[,36:40]


###################################################
### chunk number 7:  eval=FALSE
###################################################
## data(ou2)


###################################################
### chunk number 8: 
###################################################
  ou2.rprocess <- function (xstart, times, params, paramnames, ...) {
    nvar <- nrow(xstart)
    npar <- nrow(params)
    nrep <- ncol(xstart)
    ntimes <- length(times)
    ## get indices of the various parameters in the 'params' matrix
    ## C uses zero-based indexing!
    parindex <- match(paramnames,rownames(params))-1
    array(
	  .C("ou2_adv",
	     X = double(nvar*nrep*ntimes),
	     xstart = as.double(xstart),
	     par = as.double(params),
	     times = as.double(times),
	     n = as.integer(c(nvar,npar,nrep,ntimes)),
	     parindex = as.integer(parindex),
	     DUP = FALSE,
	     NAOK = TRUE,
	     PACKAGE = "pomp"
	     )$X,
	  dim=c(nvar,nrep,ntimes),
	  dimnames=list(rownames(xstart),NULL,NULL)
	  )
  }

  ou2.dprocess <- function (x, times, params, log, paramnames, ...) {
    nvar <- nrow(x)
    npar <- nrow(params)
    nrep <- ncol(x)
    ntimes <- length(times)
    parindex <- match(paramnames,rownames(params))-1
    array(
	  .C("ou2_pdf",
             d = double(nrep*(ntimes-1)),
             X = as.double(x),
	     par = as.double(params),
	     times = as.double(times),
	     n = as.integer(c(nvar,npar,nrep,ntimes)),
	     parindex = as.integer(parindex),
             give_log=as.integer(log),
	     DUP = FALSE,
	     NAOK = TRUE,
	     PACKAGE = "pomp"
	     )$d,
	  dim=c(nrep,ntimes-1)
	  )
  }


###################################################
### chunk number 9: 
###################################################
ou2 <- pomp( 
	    times=seq(1,100),
	    data=rbind(
	      y1=rep(0,100),
	      y2=rep(0,100)
	      ),
	    t0=0,
	    rprocess = ou2.rprocess,
	    dprocess = ou2.dprocess,
	    dmeasure = "normal_dmeasure",
	    rmeasure = "normal_rmeasure",
            paramnames=c(
              "alpha.1","alpha.2","alpha.3","alpha.4",
              "sigma.1","sigma.2","sigma.3",
              "tau"
              ),
            statenames = c("x1","x2"),
            PACKAGE="pomp"
	    )


###################################################
### chunk number 10: 
###################################################
p <- c(
       alpha.1=0.9,alpha.2=0,alpha.3=0,alpha.4=0.99,
       sigma.1=1,sigma.2=0,sigma.3=2,
       tau=1,x1.0=50,x2.0=-50
       )


###################################################
### chunk number 11: 
###################################################
tic <- Sys.time()
x <- simulate(ou2,params=p,nsim=500,seed=800733088)
toc <- Sys.time()
print(toc-tic)


###################################################
### chunk number 12: 
###################################################
euler.sir <- pomp(
                  times=seq(1/52,4,by=1/52),
                  data=rbind(measles=numeric(52*4)),
                  t0=0,
                  tcovar=seq(0,25,by=1/52),
                  covar=matrix(
                    periodic.bspline.basis(seq(0,25,by=1/52),nbasis=3,period=1,degree=3),
                    ncol=3,
                    dimnames=list(NULL,paste("seas",1:3,sep=''))
                    ),
                  delta.t=1/52/20,
                  statenames=c("S","I","R","cases","W"),
                  paramnames=c("gamma","mu","iota","beta1","beta.sd","pop","rho"),
                  covarnames=c("seas1"),
                  zeronames=c("cases"),
                  comp.names=c("S","I","R"),
                  step.fun="sir_euler_simulator",
                  rprocess=euler.simulate,
                  skeleton.vectorfield="sir_ODE",
                  rmeasure="binom_rmeasure",
                  dmeasure="binom_dmeasure",
                  PACKAGE="pomp",
                  initializer=function(params, t0, comp.names, ...){
                    p <- exp(params)
                    snames <- c("S","I","R","cases","W")
                    fracs <- p[paste(comp.names,"0",sep=".")]
                    x0 <- numeric(length(snames))
                    names(x0) <- snames
                    x0[comp.names] <- round(p['pop']*fracs/sum(fracs))
                    x0
                  }
                  )


###################################################
### chunk number 13: 
###################################################
coef(euler.sir) <- log(
                       c(
                         gamma=26,mu=0.02,iota=0.01,
                         beta1=1200,beta2=1800,beta3=600,
                         beta.sd=1e-3,
                         pop=2.1e6,
                         rho=0.6,
                         S.0=26/1200,I.0=0.001,R.0=1-0.001-26/1200
                         )
                       )



###################################################
### chunk number 14: 
###################################################
euler.sir <- simulate(euler.sir,nsim=1,seed=329348545L)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## data(euler.sir)


###################################################
### chunk number 16: 
###################################################
  options(glop)


