###################################################
### chunk number 1: 
###################################################
  glop <- options(keep.source=TRUE,width=60,continue=" ",prompt=" ")
  library(pomp)
  set.seed(5384959)


###################################################
### chunk number 2: 
###################################################
  ou2.rprocess <- function (xstart, times, params, ...) { 
    ## this function simulates two discrete-time OU processes
    nreps <- ncol(xstart)
    ntimes <- length(times)
    x <- array(0,dim=c(2,nreps,ntimes))
    rownames(x) <- rownames(xstart)
    x[,,1] <- xstart
    for (k in 2:ntimes) {
      for (j in 1:nreps) {
        xi <- rnorm(2,mean=0,sd=1)
        x['x1',j,k] <- params['alpha.1',j]*x['x1',j,k-1]+
                         params['alpha.3',j]*x['x2',j,k-1]+
                         params['sigma.1',j]*xi[1]
        x['x2',j,k] <- params['alpha.2',j]*x['x1',j,k-1]+
                         params['alpha.4',j]*x['x2',j,k-1]+
                         params['sigma.2',j]*xi[1]+
                         params['sigma.3',j]*xi[2]
      }
    }
    x
  }


###################################################
### chunk number 3: 
###################################################
  ou2.dprocess <- function (x, times, params, log, ...) { 
    ## this function simulates two discrete-time OU processes
    nreps <- ncol(x)
    ntimes <- length(times)
    xi.scal <- numeric(2)
    f <- array(0,dim=c(nreps,ntimes-1))
    for (k in 2:ntimes) {
      for (j in 1:nreps) {
        xi.scal[1] <- x['x1',j,k]-params['alpha.1',j]*x['x1',j,k-1]-
                        params['alpha.3',j]*x['x2',j,k-1]
        xi.scal[2] <- x['x2',j,k]-params['alpha.2',j]*x['x1',j,k-1]-
                        params['alpha.4',j]*x['x2',j,k-1]-
                        params['sigma.2',j]/params['sigma.1',j]*xi.scal[1]
        f[j,k-1] <- sum(
                        dnorm(
                              x=xi.scal,
                              mean=0,
                              sd=params[c("sigma.1","sigma.3"),j],
                              log=TRUE
                              ),
                        na.rm=T
                        )
      }
    }
    if (log) f else exp(f)
  }


###################################################
### chunk number 4: 
###################################################
  bvnorm.rmeasure <- function (x, t, params, ...) {
    ## noisy observations of the two walks with common noise SD 'tau'
    c(
      y1=rnorm(n=1,mean=x['x1'],sd=params['tau']),
      y2=rnorm(n=1,mean=x['x2'],sd=params['tau'])
      )
  }


###################################################
### chunk number 5: 
###################################################
  bvnorm.dmeasure <- function (y, t, x, params, log, ...) {
    f <- sum(
             dnorm(
                   x=y[c("y1","y2")],
                   mean=x[c("x1","x2")],
                   sd=params["tau"],
                   log=TRUE
                   ),
             na.rm=TRUE
             )
    if (log) f else exp(f)
  }


###################################################
### chunk number 6: 
###################################################
ou2 <- pomp( 
	    times=seq(1,100),
	    data=rbind(
	      y1=rep(0,100),
	      y2=rep(0,100)
	      ),
	    t0=0,
	    rprocess = ou2.rprocess,
	    dprocess = ou2.dprocess,
	    rmeasure = bvnorm.rmeasure,
	    dmeasure = bvnorm.dmeasure
	    )


###################################################
### chunk number 7: 
###################################################
true.p <- c(
            alpha.1=0.9,alpha.2=0,alpha.3=0,alpha.4=0.99,
            sigma.1=1,sigma.2=0,sigma.3=2,
            tau=1,x1.0=50,x2.0=-50
            )


###################################################
### chunk number 8: 
###################################################
## this is a check to make sure the different implementations of 'ou2' are equivalent
x <- simulate(ou2,params=true.p,nsim=2,states=T,obs=T)
new.fp <- dprocess(ou2,x=x$states,params=cbind(true.p,true.p),times=time(ou2,t0=T),log=T) 
new.fm <- dmeasure(ou2,x=x$states,y=x$obs[,1,],params=cbind(true.p,true.p),times=time(ou2,t0=T),log=T) 

data(ou2)
old.fp <- dprocess(ou2,x=x$states,params=cbind(true.p,true.p),times=time(ou2,t0=T),log=T) 
old.fm <- dmeasure(ou2,x=x$states,y=x$obs[,1,],params=cbind(true.p,true.p),times=time(ou2,t0=T),log=T) 

if ((max(abs(old.fp-new.fp))>1e-12)||(max(abs(old.fm-new.fm))>1e-12)) stop("error in scratchy code")


###################################################
### chunk number 9: 
###################################################
 ou2 <- simulate(ou2,params=true.p,nsim=1000,seed=800733088)
 ou2 <- ou2[[1]]


###################################################
### chunk number 10:  eval=FALSE
###################################################
## as(ou2,'data.frame')


###################################################
### chunk number 11:  eval=FALSE
###################################################
## data.array(ou2)
## time(ou2)  
## time(ou2,t0=TRUE)  


###################################################
### chunk number 12:  eval=FALSE
###################################################
## coef(ou2)
## coef(ou2,c("sigma.1","sigma.2")) <- c(1,0)


###################################################
### chunk number 13: 
###################################################
plot(ou2)


###################################################
### chunk number 14: 
###################################################
ou2 <- pomp( 
	    times=seq(1,100),
	    data=rbind(
	      y1=rep(0,100),
	      y2=rep(0,100)
	      ),
	    t0=0,
            rprocess = onestep.simulate,
            dprocess = onestep.density,
            step.fun = function(x, t, params, delta.t, ...) {
              eps <- rnorm(n=2)
              with(
                   as.list(c(x,params)),
                   c(
                     x1=alpha.1*x1+alpha.3*x2+sigma.1*eps[1],
                     x2=alpha.2*x1+alpha.4*x2+sigma.2*eps[1]+sigma.3*eps[2]
                     )
                   )
            },
            dens.fun = function (x1, t1, x2, t2, params, ...) {
              eps.1 <- x2['x1']-params['alpha.1']*x1['x1']-
                         params['alpha.3']*x1['x2']
              eps.2 <- x2['x2']-params['alpha.2']*x1['x1']-
                         params['alpha.4']*x1['x2']-
                         params['sigma.2']/params['sigma.1']*eps.1
              sum(
                  dnorm(
                        c(eps.1,eps.2),
                        mean=0,
                        sd=params[c('sigma.1','sigma.3')],
                        log=T
                        ),
                  na.rm=T
                  )
            },
	    rmeasure = bvnorm.rmeasure,
	    dmeasure = bvnorm.dmeasure
	    )


###################################################
### chunk number 15: 
###################################################
## this is a check to make sure the different implementations of 'ou2' are equivalent
x <- simulate(ou2,params=true.p,nsim=2,states=T,obs=T)
new.fp <- dprocess(ou2,x=x$states,params=cbind(true.p,true.p),times=time(ou2,t0=T),log=T) 
new.fm <- dmeasure(ou2,x=x$states,y=x$obs[,1,],params=cbind(true.p,true.p),times=time(ou2,t0=T),log=T) 

data(ou2)
old.fp <- dprocess(ou2,x=x$states,params=cbind(true.p,true.p),times=time(ou2,t0=T),log=T) 
old.fm <- dmeasure(ou2,x=x$states,y=x$obs[,1,],params=cbind(true.p,true.p),times=time(ou2,t0=T),log=T) 

if ((max(abs(old.fp-new.fp))>1e-12)||(max(abs(old.fm-new.fm))>1e-12)) stop("error in plugin code")


###################################################
### chunk number 16: 
###################################################
set.seed(74094853)


###################################################
### chunk number 17: 
###################################################
data(ou2)
fit1 <- pfilter(ou2,params=true.p,Np=1000,filter.mean=T,pred.mean=T,pred.var=T)


###################################################
### chunk number 18:  eval=FALSE
###################################################
## fit1 <- pfilter(ou2,Np=1000)


###################################################
### chunk number 19: 
###################################################
kalman.filter <- function (y, x0, a, b, sigma, tau) {
  n <- nrow(y)
  ntimes <- ncol(y)
  sigma.sq <- sigma%*%t(sigma)
  tau.sq <- tau%*%t(tau)
  inv.tau.sq <- solve(tau.sq)
  cond.dev <- numeric(ntimes)
  filter.mean <- matrix(0,n,ntimes)
  pred.mean <- matrix(0,n,ntimes)
  pred.var <- array(0,dim=c(n,n,ntimes))
  dev <- 0
  m <- x0
  v <- diag(0,n)
  for (k in seq(length=ntimes)) {
    pred.mean[,k] <- M <- a%*%m
    pred.var[,,k] <- V <- a%*%v%*%t(a)+sigma.sq
    q <- b%*%V%*%t(b)+tau.sq
    r <- y[,k]-b%*%M
    cond.dev[k] <- n*log(2*pi)+log(det(q))+t(r)%*%solve(q,r)
    dev <- dev+cond.dev[k]
    q <- t(b)%*%inv.tau.sq%*%b+solve(V)
    v <- solve(q)
    filter.mean[,k] <- m <- v%*%(t(b)%*%inv.tau.sq%*%y[,k]+solve(V,M))
  }
  list(
       pred.mean=pred.mean,
       pred.var=pred.var,
       filter.mean=filter.mean,
       cond.loglik=-0.5*cond.dev,
       loglik=-0.5*dev
       )
}


###################################################
### chunk number 20: 
###################################################
y <- data.array(ou2)
a <- matrix(true.p[c('alpha.1','alpha.2','alpha.3','alpha.4')],2,2)
b <- diag(1,2)   ## b is the identity matrix
sigma <- matrix(c(true.p['sigma.1'],true.p['sigma.2'],0,true.p['sigma.3']),2,2)
tau <- diag(true.p['tau'],2,2)
x0 <- init.state(ou2)
fit2 <- kalman.filter(y,x0,a,b,sigma,tau)


###################################################
### chunk number 21: 
###################################################
start.p <- true.p
start.p[c('x1.0','x2.0','alpha.1','alpha.4')] <- c(45,-60,0.8,0.9)
fit <- mif(ou2,Nmif=1,start=start.p,
           pars=c('alpha.1','alpha.4'),ivps=c('x1.0','x2.0'),
           rw.sd=c(
             x1.0=5,x2.0=5,
             alpha.1=0.1,alpha.4=0.1
             ),
           Np=1000,
           var.factor=1,
           ic.lag=10,
           cooling.factor=0.95,
           max.fail=100
           )
fit <- continue(fit,Nmif=79,max.fail=100)
fitted.pars <- c("alpha.1","alpha.4","x1.0","x2.0")
cbind(
      start=start.p[fitted.pars],
      mle=signif(coef(fit,fitted.pars),3),
      truth=true.p[fitted.pars]
      )


###################################################
### chunk number 22:  eval=FALSE
###################################################
## plot(fit)


###################################################
### chunk number 23: 
###################################################
x <- conv.rec(fit,c("loglik","alpha.1","alpha.4"))
op <- par(fig=c(0,1,0.66,0.99),mar=c(0,4,4,0))
plot(x[,"loglik"],type='l',bty='l',xlab='',ylab=expression(log(L)),xaxt='n')
par(fig=c(0,1,0.33,0.66),mar=c(2,4,2,0),new=T)
plot(x[,"alpha.1"],type='l',bty='l',xlab='',ylab=expression(alpha[1]),xaxt='n')
par(fig=c(0,1,0.0,0.33),mar=c(4,4,0,0),new=T)
plot(x[,"alpha.4"],type='l',bty='l',xlab="MIF iteration",ylab=expression(alpha[4]))
par(op)


###################################################
### chunk number 24: 
###################################################
round(pfilter(fit)$loglik,1)


###################################################
### chunk number 25: 
###################################################
plot(simulate(fit))


###################################################
### chunk number 26: 
###################################################
  options(glop)


