### Name: rtlu
### Title: ~ Function: R to LaTeX, Univariate analysis ~
### Aliases: rtlu
### Keywords: print classes programming interface utilities univar

### ** Examples

 # # # # # # # # # # # # # # # # # # #
#   R to LaTeX, Univariate Analyses   #
 #             Examples              #
  #       rtlu single variable      #
   # # # # # # # # # # # # # # # # #

########################
###### Step 1: Create the data
par(ask=FALSE)
V1 <- factor(LETTERS[floor(runif(50,1,4))])
V2 <- rnorm(50,1,1)<0
V3 <- ordered(LETTERS[floor(runif(50,1,4))])

########################
###### Step 2: ordering variable
# nothing to do

########################
###### Step 3: running r2lu

### The following code will create some files.
### So we first move in a directories.

if(!file.exists("exampleSingle")){dir.create("exampleSingle")}else{}
setwd("exampleSingle")
try(rtlu(V1,fileOutput="first.tex",textBefore="\section{Variable 1 to 3}",graphName="V1"))
try(rtlu(V2,fileOut="second.tex",graphName="V2"))
try(rtlu(V3,fileOut="third.tex",textBefore="This is variable 3",graphDir="P"))
rtluMainFile(text="\input{first.tex}\n\input{second.tex}\n\input{third.tex}")
setwd("..")



 # # # # # # # # # # # # # # # # # # #
#   R to LaTeX, Univariate Analyses   #
 #          Real examples            #
  #        rtlu data.frame          #
   # # # # # # # # # # # # # # # # #

########################
###### Step 1: Create the data

data(examCheating)
str(examCheating)

########################
###### Step 2: ordering variable

examCheating$YearOfStudy <- ordered(examCheating$YearOfStudy,levels=c("L1","L2","L3","M1","M2"))
examCheating$Bac <- ordered(examCheating$Bac,levels=c("Remedial exam","Pass","Fairly good","Good","Very good","Summa cum laude"))
for(iColumn in 8:17){
    examCheating[,iColumn] <- ordered(examCheating[,iColumn],levels=c("Never","Rarely","Sometimes","Often","Always"))
}
str(examCheating)

########################
###### Step 3: running r2lu

### The following code will create some files.
### So we first move in a directories.

if(!file.exists("exampleReal")){dir.create("exampleReal")}else{}
setwd("exampleReal")

### Then we prepare the textBefore, for transition between variable

textBefore <- paste("\subsection{",names(examCheating)[c(2:5,18:20)],"}",sep="")

text <- "\tableofcontents
\section{Survey}
  \begin{enumerate}
    \item What is your age?
    \item What is your gender?
    \item What is your level?
    \item What is your field?
    \item Did you cheat at Bac?
    \item Did you cheat high scool?
    \item Cheating score
  \end{enumerate}
\section{Univariate analysis}
  \input{ExamCheat-univ.tex}

\section{More information?}
For a detailled analysis, see
http://christophe.genolini.free.fr/EPO/2007 Fraude/EPO2007-Fraude-Rapport.pdf"

### We can run r2lu
try(rtlu(examCheating[,c(2:5,18:20)],fileOutput="ExamCheat-univ.tex",textBefore=textBefore))
rtluMainFile("ExamCheat-main.tex",text=text)
setwd("..")

### Then compile main.tex twice. It is ready !



