### Name: pumps
### Title: 10 Power Plant Pumps
### Aliases: pumps
### Keywords: datasets

### ** Examples

data(pumps)
pumps.data <- list(t = pumps$t, x = pumps$x, N = nrow(pumps))
pumps.model <- file.path(.path.package("rbugs"), "bugs/model", "pumps.bug")
file.show(pumps.model)
pumps.inits <- file.path(.path.package("rbugs"), "bugs/inits", "pumps.txt")
file.show(pumps.inits)
inits <- list(dget(pumps.inits))
parameters <- c("theta", "alpha", "beta")

## Not run: 
##D ## Define the full name of bugs in .Renviron.
##D ## In .Renviron, add a line similar to this:
##D ##  BUGS="c:/program files/winbugs14/winbugs14.exe"
##D 
##D pumps.sim <- rbugs(data = pumps.data, inits, parameters,
##D                    pumps.model, n.chains = 1, n.iter = 1000,
##D                    bugs="e:/program files/winbugs14/winbugs14.exe")
## End(Not run)



