### Name: schools
### Title: 8 schools
### Aliases: schools
### Keywords: datasets

### ** Examples

data(schools)
J <- nrow(schools)
y <- schools$estimate
y <- rnorm(length(y))
sigma.y <- schools$sd
schools.data <- list ("J", "y", "sigma.y") 
## schools.data <- list(J=J, y=y, sigma.y=sigma.y)
inits <- function() {list (theta=rnorm(J,0,100),
                           mu.theta=rnorm(1,0,100),
                           sigma.theta=runif(1,0,100))}
parameters <- c("theta", "mu.theta", "sigma.theta")
schools.bug <- file.path(.path.package("rbugs"), "bugs/model", "schools.bug")
file.show(schools.bug)
## Not run: 
##D ## no tested examples for mac-os.
##D schools.sim <- rbugs(data=schools.data, inits, parameters,
##D                      schools.bug, n.chains=3, n.iter=1000,
##D                      bugs="d:/Program Files/WinBUGS14/WinBUGS14.exe",
##D                      bugsWorkingDir="e:/temp", 
##D                      debug=TRUE)
##D                      
## End(Not run)



