### Name: autorun.jags
### Title: Run a User Specified Bayesian MCMC Model in JAGS with
###   Automatically Calculated Run Length and Convergence Diagnostics
### Aliases: autorun.jags autorun.JAGS
### Keywords: models

### ** Examples

# run a model to calculate the intercept and slope of the expression y = m x + c, assuming normal observation errors for y:

## Not run: 
##D # Simulate the data
##D x <- 1:100
##D y <- rnorm(length(x), 2*x + 10, 1)
##D 
##D # Model in the JAGS format
##D model <- "model {
##D for(i in 1 : N){
##D Y[i] ~ dnorm(true.y[i], precision);
##D true.y[i] <- (m * X[i]) + c;
##D }
##D m ~ dunif(-1000,1000);
##D c ~ dunif(-1000,1000);
##D precision ~ dexp(1);
##D }"
##D 
##D # Convert the data to a named list
##D data <- list(X=x, Y=y, N=length(x))
##D 
##D # Run the model
##D results <- autorun.jags(model=model, monitor=c("m", "c", "precision"), data=data)
##D 
##D # Analyse traceplots of the results to assess convergence:
##D results$trace
##D 
##D # Summary of monitored variables:
##D results$summary
## End(Not run)



