### Name: autorun.jagsfile
### Title: Read a User Specified Model in a WinBUGS Type Textfile or
###   Character Variable, and Run the Simulation in JAGS with Automatically
###   Calculated Run Length and Convergence Diagnostics
### Aliases: autorun.jagsfile autorun.JAGSfile
### Keywords: models

### ** Examples

# run a model to calculate the intercept and slope of the expression y = m x + c, assuming normal observation errors for y:

## Not run: 
##D 
##D # Model in the JAGS format
##D model <- "model {
##D for(i in 1 : N){ #data# N
##D Y[i] ~ dnorm(true.y[i], precision); #data# Y
##D true.y[i] <- (m * X[i]) + c; #data# X
##D }
##D m ~ dunif(-1000,1000); #inits# m
##D c ~ dunif(-1000,1000);
##D precision ~ dexp(1);
##D #monitor# m, c, precision
##D }"
##D 
##D # Simulate the data
##D X <- 1:100
##D Y <- rnorm(length(X), 2*X + 10, 1)
##D N <- length(X)
##D 
##D initfunction <- function(chain) return(switch(chain, "1"=list(m=-10), "2"=list(m=10)))
##D 
##D results <- autorun.jagsfile(model, n.chains=2, initlist=initfunction)
##D 
##D # Analyse traceplots of the results to assess convergence:
##D results$trace
##D 
##D # Analyse the results
##D results$summary
## End(Not run)



