### Name: combine.mcmc
### Title: Combine Two or More MCMC Objects With the Same Number of Chains
###   Into One Longer MCMC Object
### Aliases: combine.mcmc combine.MCMC
### Keywords: methods

### ** Examples


# run a model, then extend the simulation and combine the two MCMC objects, with thinning to 5000 samples.

## Not run: 
##D 
##D # Model in the JAGS format
##D model <- "model {
##D for(i in 1 : N){ #data# N
##D Y[i] ~ dnorm(true.y[i], precision); #data# Y
##D true.y[i] <- (m * X[i]) + c; #data# X
##D }
##D m ~ dunif(-1000,1000);
##D c ~ dunif(-1000,1000);
##D precision ~ dexp(1);
##D #monitor# m, c, precision
##D }"
##D 
##D # Simulate the data
##D X <- 1:100
##D Y <- rnorm(length(X), 2*X + 10, 1)
##D N <- length(X)
##D 
##D results1 <- run.jagsfile(model, n.chains=2, burnin=5000, sample=10000)
##D results2 <- run.jagsfile(model, inits=results1$end.state, burnin=0, sample=10000)
##D 
##D results <- combine.mcmc(list(results1$mcmc, results2$mcmc), return.samples=5000)
##D 
##D # Analyse the results
##D summary(results)
## End(Not run)



