### Name: read.winbugs
### Title: Extract Any Models, Data, Monitored Variables or Initial Values
###   As Character Vectors from a Winbugs Type Textfile
### Aliases: read.winbugs read.WinBUGS
### Keywords: methods

### ** Examples


## Not run: 
##D 
##D # ALL SYNTAX GIVEN BELOW IS EQUIVALENT
##D 
##D # Use a modified WinBUGS text file with manual inits and manual data and a seperate monitor block (requires least modification from a WinBUGS file).  For compatibility with WinBUGS, the use of list() to enclose data and initial values is allowed and ignored, however all seperate variables in the data and inits blocks must be seperated with a line break (commas or semicolons before linebreaks are ignored).  'data{' and 'inits{' must also be added to WinBUGS textfiles so that the function can seperate data from initial values.  Iterative loops are allowed in data blocks but not in init blocks.  See also the differences in JAGS versus WinBUGS syntax in the JAGS help file.
##D 
##D # Contents of a textfile 'mymodel.bug':
##D 
##D model{
##D 
##D         for(i in 1:N){
##D                 Count[i] ~ dpois(mean)
##D         }
##D         mean ~ dgamma(0.01, 100)
##D }
##D 
##D data{
##D list(Count <- c(1,2,3,4,5,6,7,8,9,10),
##D N <- 10)
##D 
##D }
##D inits{
##D list(
##D         mean <- 1)
##D }
##D 
##D inits{
##D list(
##D         mean <- 100)
##D }
##D 
##D monitor{
##D         mean
##D }
##D 
##D # end text file
##D 
##D read.winbugs('pathtofile/mymodel.bug')
##D 
##D # Use internal character variable, define monitors in the model, use autodata and manual initial values:
##D 
##D string <- "
##D model{
##D 
##D         for(i in 1:N){
##D                 Count[i] ~ dpois(mean) #data# Count, N
##D         }
##D         mean ~ dgamma(0.01, 100)
##D         #monitor# mean
##D }
##D 
##D inits{
##D         mean <- 1
##D }
##D 
##D inits{
##D         mean <- 100
##D }
##D "
##D 
##D read.winbugs(string)
##D 
##D # Use autoinits and a mixture of manual and autodata:
##D string <- "
##D model{
##D 
##D         for(i in 1:N){ 
##D                 Count[i] ~ dpois(mean) #data# Count
##D         }
##D         mean ~ dgamma(0.01, 100) 
##D         #monitor# mean
##D         #inits# mean
##D }
##D 
##D data{
##D 
##D         N <- 10
##D 
##D }
##D "
##D 
##D read.winbugs(string)
##D 
## End(Not run)




