### Name: run.jags
### Title: Run a User Specified Bayesian MCMC Model in JAGS from Within R
### Aliases: run.jags run.JAGS
### Keywords: models

### ** Examples

# run a model to calculate the intercept and slope of the expression y = m x + c, assuming normal observation errors for y:

## Not run: 
##D 
##D # Simulate the data
##D X <- 1:100
##D Y <- rnorm(length(X), 2*X + 10, 1)
##D 
##D # Model in the JAGS format
##D model <- "model {
##D for(i in 1 : N){
##D Y[i] ~ dnorm(true.y[i], precision);
##D true.y[i] <- (m * X[i]) + c;
##D }
##D m ~ dunif(-1000,1000);
##D c ~ dunif(-1000,1000);
##D precision ~ dexp(1);
##D }"
##D 
##D # Use dump.format to convert the data and initial values files into the R dump format, with explicit control over the random number generator used for each chain (optional):
##D data <- dump.format(list(X=X, Y=Y, N=length(X)))
##D inits1 <- dump.format(list(m=1, c=1, precision=1, .RNG.name="base::Super-Duper", .RNG.seed=1))
##D inits2 <- dump.format(list(m=0.1, c=10, precision=1, .RNG.name="base::Wichmann-Hill", .RNG.seed=2))
##D 
##D # Run the model and produce plots
##D results <- run.jags(model=model, monitor=c("m", "c", "precision"), data=data, n.chains=2, inits=c(inits1,
##D inits2), plots = TRUE)
##D 
##D # Density plots of the monitored variables:
##D results$density
##D 
##D # Analyse the results
##D results$summary
## End(Not run)




