### Name: skmeans
### Title: Compute Spherical k-Means Partitions
### Aliases: skmeans
### Keywords: cluster

### ** Examples

## Use CLUTO dataset 're0':
x <- readCM(system.file("cluto", "re0.mat",
                        package = "skmeans"),
            system.file("cluto", "re0.mat.clabel",
                        package = "skmeans"))
## Which is not really small:
dim(x)
## Partition into 5 clusters.
party <- skmeans(x, 5, control = list(verbose = TRUE))
## Criterion value obtained:
party$value
## Compare with "true" classifications:
class_ids <-
    readLines(system.file("cluto", "re0.mat.rclass",
                          package = "skmeans"))
table(class_ids, party$cluster)



