### Name: sn.mle.grouped
### Title: Maximum likelihood estimation of SN and ST distribution for
###   grouped data
### Aliases: sn.mle.grouped st.mle.grouped
### Keywords: distribution

### ** Examples

data(ais, package="sn")
attach(ais)
breaks<- c(130,160, seq(170, 190, by=2.5), 200, 230)
f <- cut(Ht[sex=="female"], breaks = breaks)
freq <- tabulate(f, length(levels(f)))
b1 <- sn.mle.grouped(breaks, freq)
b2 <- st.mle.grouped(breaks, freq, start=c(b1$end,log(5)))
print(b2$dp)
#
us.income <- c(0,seq(from=0.2, to=1.8, by=0.1), 2.0, 2.5, 5.0, Inf)
mid <- (us.income[-1]+us.income[-length(us.income)])/2
mid[length(mid)] <- 6.5
cum.freq<- c(1.78, 3.25, 5.56, 8.16, 11.12, 14.21, 17.54, 20.78, 24.00,
             27.52, 30.77, 34.21, 37.56, 40.70, 44.41, 47.85, 51.22, 
             57.60, 72.12, 96.40, 100) / 100
freq<- round(diff(c(0,cum.freq*34660)))
a <- st.mle.grouped(breaks=log(us.income), freq, trace=TRUE,
        start=c(1.2, log(0.9), -2.1, log(20)))
print(a$dp)



