### Name: EBest
### Title: Global Empirical Bayes estimator
### Aliases: EBest
### Keywords: spatial

### ** Examples

example(auckland)
res <- EBest(auckland$M77_85, 9*auckland$Und5_81)
attr(res, "parameters")
cols <- grey(6:2/7)
brks <- c(-Inf,2,2.5,3,3.5,Inf)
plot(auckland, col=cols[findInterval(res$estmm*1000, brks, all.inside=TRUE)])
legend("bottomleft", fill=cols, legend=leglabs(brks), bty="n")
title(main="Global moment estimator of infant mortality per 1000 per year")
data(huddersfield)
res <- EBest(huddersfield$cases, huddersfield$total, family="binomial")
round(res[,1:2],4)*100



