### Name: as_dgRMatrix_listw
### Title: Interface between Matrix class objects and weights lists
### Aliases: as_dgRMatrix_listw as_dsTMatrix_listw as_dsCMatrix_I
###   as_dsCMatrix_IrW Jacobian_W
### Keywords: spatial

### ** Examples

example(NY_data)
W <- as_dsTMatrix_listw(listw_NY)
I <- as_dsCMatrix_I(dim(W)[1])
W <- as(W, "CsparseMatrix")
rho <- 0.1
c(determinant(I - rho * W, logarithm=TRUE)$modulus)
sum(log(1 - rho * eigenw(listw_NY)))
n <- dim(W)[1]
nW <- - W
nChol <- Cholesky(nW, Imult=8)
.f <- if(package_version(packageDescription("Matrix")$Version) >
           "0.999375-30") 2 else 1
n * log(rho) + (.f * c(determinant(update(nChol, nW, 1/rho))$modulus))
rho <- seq(0.01, 0.1, 0.01)
n * log(rho) + Matrix:::ldetL2up(nChol, nW, 1/rho)



