### Name: house
### Title: Lucas county OH housing
### Aliases: house LO_nb trMat
### Keywords: datasets

### ** Examples

## Not run: 
##D house <- read.table("house.dat", header=FALSE)
##D names(house) <- c("price", "yrbuilt", "stories", "TLA", "wall", "beds",
##D   "baths", "halfbaths", "frontage", "depth", "garage", "garagesqft", "rooms",
##D   "lotsize", "sdate", "avalue", "long", "lat", "s1993", "s1994", "s1995",
##D   "s1996", "s1997", "s1998")
##D house$syear <- 1992 + house$s1993 + 2*house$s1994 + 3*house$s1995 +
##D 4*house$s1996 + 5*house$s1997 + 6*house$s1998
##D house$syear <- factor(house$syear)
##D house$age <- (1999 - house$yrbuilt)/100
##D house$stories <- factor(house$stories, levels=1:7, labels=c("one",
##D  "bilevel", "multilvl", "one+half", "two", "two+half", "three"))
##D house$wall <- factor(house$wall, levels=1:7, labels=c("stucdrvt",
##D  "ccbtile", "metlvnyl", "brick", "stone", "wood", "partbrk"))
##D house$garage <- factor(house$garage, levels=0:4, labels=c("no garage",
##D  "basement", "attached", "detached", "carport"))
##D library(sp)
##D coordinates(house) <- c("long", "lat")
##D proj4string(house) <- CRS("+proj=longlat")
##D library(rgdal)
##D house <- spTransform(house, CRS("+init=epsg:2834"))
##D library(spdep)
##D LO_nb <- graph2nb(soi.graph(tri2nb(coordinates(house)), coordinates(house)))
##D W <- as(as_dgRMatrix_listw(nb2listw(LO_nb)), "CsparseMatrix")
##D trMat <- trW(W, type="mult")
## End(Not run)
data(house)
## maybe str(house) ; plot(house) ...



