### Name: impacts
### Title: Impacts in spatial lag models
### Aliases: impacts impacts.sarlm impacts.stsls plot.lagImpact
###   print.lagImpact summary.lagImpact print.summary.lagImpact
###   HPDinterval.lagImpact
### Keywords: spatial

### ** Examples

example(columbus)
listw <- nb2listw(col.gal.nb)
lobj <- lagsarlm(CRIME ~ INC + HOVAL, columbus, listw)
summary(lobj)
mobj <- lagsarlm(CRIME ~ INC + HOVAL, columbus, listw, type="mixed")
summary(mobj)
W <- as(as_dgRMatrix_listw(listw), "CsparseMatrix")
trMatc <- trW(W, type="mult")
trMC <- trW(W, type="MC")
impacts(lobj, listw=listw)
impacts(lobj, tr=trMatc)
impacts(lobj, tr=trMC)
lobj1 <- stsls(CRIME ~ INC + HOVAL, columbus, listw)
loobj1 <- impacts(lobj1, tr=trMatc, R=200)
summary(loobj1, zstats=TRUE, short=TRUE)
lobj1r <- stsls(CRIME ~ INC + HOVAL, columbus, listw, robust=TRUE)
loobj1r <- impacts(lobj1r, tr=trMatc, R=200)
summary(loobj1r, zstats=TRUE, short=TRUE)
lobjIQ5 <- impacts(lobj, tr=trMatc, R=200, Q=5)
summary(lobjIQ5, zstats=TRUE, short=TRUE)
summary(lobjIQ5, zstats=TRUE, short=TRUE, reportQ=TRUE)
impacts(mobj, listw=listw)
impacts(mobj, tr=trMatc)
impacts(mobj, tr=trMC)
summary(impacts(mobj, tr=trMatc, R=200), zstats=TRUE)
## Not run: 
##D mobj1 <- lagsarlm(CRIME ~ INC + HOVAL, columbus, listw, type="mixed", 
##D method="Matrix", fdHess=TRUE)
##D summary(mobj1)
##D summary(impacts(mobj1, tr=trMatc, R=1000), zstats=TRUE, short=TRUE)
##D summary(impacts(mobj, tr=trMatc, R=1000), zstats=TRUE, short=TRUE)
##D mobj2 <- lagsarlm(CRIME ~ INC + HOVAL, columbus, listw, type="mixed", 
##D method="Matrix", fdHess=TRUE, optimHess=TRUE)
##D summary(impacts(mobj2, tr=trMatc, R=1000), zstats=TRUE, short=TRUE)
##D mobj3 <- lagsarlm(CRIME ~ INC + HOVAL, columbus, listw, type="mixed", 
##D method="spam", fdHess=TRUE)
##D summary(impacts(mobj3, tr=trMatc, R=1000), zstats=TRUE, short=TRUE)
##D data(boston)
##D Wb <- as(as_dgRMatrix_listw(nb2listw(boston.soi)), "CsparseMatrix")
##D trMatb <- trW(Wb, type="mult")
##D gp2mMi <- lagsarlm(log(CMEDV) ~ CRIM + ZN + INDUS + CHAS + I(NOX^2) + 
##D I(RM^2) +  AGE + log(DIS) + log(RAD) + TAX + PTRATIO + B + log(LSTAT), 
##D data=boston.c, nb2listw(boston.soi), type="mixed", method="Matrix", 
##D fdHess=TRUE, trs=trMatb)
##D summary(gp2mMi)
##D summary(impacts(gp2mMi, tr=trMatb, R=1000), zstats=TRUE, short=TRUE)
##D data(house)
##D lw <- nb2listw(LO_nb)
##D form <- formula(log(price) ~ age + I(age^2) + I(age^3) + log(lotsize) +
##D    rooms + log(TLA) + beds + syear)
##D lobj <- lagsarlm(form, house, lw, method="Matrix",
##D  fdHess=TRUE, trs=trMat)
##D summary(lobj)
##D loobj <- impacts(lobj, tr=trMat, R=1000)
##D summary(loobj, zstats=TRUE, short=TRUE)
##D lobj1 <- stsls(form, house, lw)
##D loobj1 <- impacts(lobj1, tr=trMat, R=1000)
##D summary(loobj1, zstats=TRUE, short=TRUE)
##D mobj <- lagsarlm(form, house, lw, type="mixed",
##D  method="Matrix", fdHess=TRUE, trs=trMat)
##D summary(mobj)
##D moobj <- impacts(mobj, tr=trMat, R=1000)
##D summary(moobj, zstats=TRUE, short=TRUE)
## End(Not run)



