### Name: invIrM
### Title: Compute SAR generating operator
### Aliases: invIrM invIrW powerWeights
### Keywords: spatial

### ** Examples


nb7rt <- cell2nb(7, 7, torus=TRUE)
set.seed(1)
x <- matrix(rnorm(500*length(nb7rt)), nrow=length(nb7rt))
res0 <- apply(invIrM(nb7rt, rho=0.0, method="chol",
 feasible=TRUE) %*% x, 2, function(x) var(x)/length(x))
res2 <- apply(invIrM(nb7rt, rho=0.2, method="chol",
 feasible=TRUE) %*% x, 2, function(x) var(x)/length(x))
res4 <- apply(invIrM(nb7rt, rho=0.4, method="chol",
 feasible=TRUE) %*% x, 2, function(x) var(x)/length(x))
res6 <- apply(invIrM(nb7rt, rho=0.6, method="chol",
 feasible=TRUE) %*% x, 2, function(x) var(x)/length(x))
res8 <- apply(invIrM(nb7rt, rho=0.8, method="chol",
 feasible=TRUE) %*% x, 2, function(x) var(x)/length(x))
res9 <- apply(invIrM(nb7rt, rho=0.9, method="chol",
 feasible=TRUE) %*% x, 2, function(x) var(x)/length(x))
plot(density(res9), col="red", xlim=c(-0.01, max(density(res9)$x)),
  ylim=range(density(res0)$y),
  xlab="estimated variance of the mean",
  main=expression(paste("Effects of spatial autocorrelation for different ",
    rho, " values")))
lines(density(res0), col="black")
lines(density(res2), col="brown")
lines(density(res4), col="green")
lines(density(res6), col="orange")
lines(density(res8), col="pink")
legend(c(-0.02, 0.01), c(7, 25),
 legend=c("0.0", "0.2", "0.4", "0.6", "0.8", "0.9"),
 col=c("black", "brown", "green", "orange", "pink", "red"), lty=1, bty="n")
## Not run: 
##D x <- matrix(rnorm(length(nb7rt)), ncol=1)
##D system.time(e <- invIrM(nb7rt, rho=0.9, method="chol", feasible=TRUE) %*% x)
##D system.time(e <- invIrM(nb7rt, rho=0.9, method="chol", feasible=NULL) %*% x)
##D system.time(e <- invIrM(nb7rt, rho=0.9, method="solve", feasible=TRUE) %*% x)
##D system.time(e <- invIrM(nb7rt, rho=0.9, method="solve", feasible=NULL) %*% x)
##D W <- as(as_dgRMatrix_listw(nb2listw(nb7rt)), "CsparseMatrix")
##D system.time(ee <- powerWeights(W, rho=0.9, X=x))
##D all.equal(e, as(ee, "matrix"), check.attributes=FALSE)
##D nb60rt <- cell2nb(60, 60, torus=TRUE)
##D W <- as(as_dgRMatrix_listw(nb2listw(nb60rt)), "CsparseMatrix")
##D set.seed(1)
##D x <- matrix(rnorm(dim(W)[1]), ncol=1)
##D system.time(ee <- powerWeights(W, rho=0.3, X=x))
##D str(as(ee, "matrix"))
##D obj <- errorsarlm(as(ee, "matrix")[,1] ~ 1, listw=nb2listw(nb60rt), method="Matrix")
##D coefficients(obj)
## End(Not run)



