### Name: localmoran.exact
### Title: Exact local Moran's Ii tests
### Aliases: localmoran.exact localmoran.exact.alt print.localmoranex
###   as.data.frame.localmoranex
### Keywords: spatial

### ** Examples

eire <- readShapePoly(system.file("etc/shapes/eire.shp", package="spdep")[1],
  ID="names", proj4string=CRS("+proj=utm +zone=30 +units=km"))
eire.nb <- poly2nb(eire)
#data(eire)
e.lm <- lm(OWNCONS ~ ROADACC, data=eire)
localmoran.sad(e.lm, nb=eire.nb)
localmoran.exact(e.lm, nb=eire.nb)
localmoran.exact(e.lm, nb=eire.nb, useTP=TRUE)
e.errorsar <- errorsarlm(OWNCONS ~ ROADACC, data=eire, listw=nb2listw(eire.nb))
localmoran.exact.alt(e.errorsar$lm.target, nb=eire.nb)
Omega <- invIrW(nb2listw(eire.nb), rho=0.6)
Omega1 <- tcrossprod(Omega)
localmoran.exact.alt(e.errorsar$lm.target, nb=eire.nb, Omega=Omega1)
localmoran.exact.alt(e.errorsar$lm.target, nb=eire.nb, Omega=Omega1, useTP=TRUE)



