### Name: localmoran.sad
### Title: Saddlepoint approximation of local Moran's Ii tests
### Aliases: localmoran.sad listw2star print.summary.localmoransad
###   summary.localmoransad print.localmoransad as.data.frame.localmoransad
### Keywords: spatial

### ** Examples

eire <- readShapePoly(system.file("etc/shapes/eire.shp", package="spdep")[1],
  ID="names", proj4string=CRS("+proj=utm +zone=30 +units=km"))
eire.nb <- poly2nb(eire)
#data(eire)
e.lm <- lm(OWNCONS ~ ROADACC, data=eire)
e.locmor <- summary(localmoran.sad(e.lm, nb=eire.nb))
e.locmor
mean(e.locmor[,1])
lm.morantest(e.lm, nb2listw(eire.nb))
hist(e.locmor[,"Pr. (Sad)"])
e.wlm <- lm(OWNCONS ~ ROADACC, data=eire, weights=RETSALE)
e.locmorw1 <- summary(localmoran.sad(e.wlm, nb=eire.nb, resfun=weighted.residuals))
e.locmorw1
e.locmorw2 <- summary(localmoran.sad(e.wlm, nb=eire.nb, resfun=rstudent))
e.locmorw2
e.errorsar <- errorsarlm(OWNCONS ~ ROADACC, data=eire,
  listw=nb2listw(eire.nb))
e.errorsar
e.clocmor <- summary(localmoran.sad(e.errorsar$lm.target, nb=eire.nb))
e.clocmor
hist(e.clocmor[,"Pr. (Sad)"])



