### Name: nc.sids
### Title: North Carolina SIDS data
### Aliases: nc.sids ncCR85.nb ncCC89.nb sidspolys sidscents
### Keywords: datasets

### ** Examples

nc.sids <- readShapePoly(system.file("etc/shapes/sids.shp", package="spdep")[1],
  ID="FIPSNO", proj4string=CRS("+proj=longlat +ellps=clrk66"))
rn <- sapply(slot(nc.sids, "polygons"), function(x) slot(x, "ID"))
ncCC89_nb <- read.gal(system.file("etc/weights/ncCC89.gal", package="spdep")[1],
  region.id=rn)
ncCR85_nb <- read.gal(system.file("etc/weights/ncCR85.gal", package="spdep")[1],
  region.id=rn)
## Not run: 
##D plot(nc.sids, border="grey")
##D plot(ncCR85_nb, coordinates(nc.sids), add=TRUE, col="blue")
##D plot(nc.sids, border="grey")
##D plot(ncCC89_nb, coordinates(nc.sids), add=TRUE, col="blue")
## End(Not run)



