### Name: probmap
### Title: Probability mapping for rates
### Aliases: probmap
### Keywords: spatial

### ** Examples

example(auckland)
res <- probmap(auckland$M77_85, 9*auckland$Und5_81)
brks <- c(-Inf,2,2.5,3,3.5,Inf)
cols <- grey(6:2/7)
plot(auckland, col=cols[findInterval(res$raw*1000, brks, all.inside=TRUE)])
legend("bottomleft", fill=cols, legend=leglabs(brks), bty="n")
title(main="Crude (raw) estimates of infant mortality per 1000 per year")
brks <- c(-Inf,47,83,118,154,190,Inf)
cols <- cm.colors(6)
plot(auckland, col=cols[findInterval(res$relRisk, brks, all.inside=TRUE)])
legend("bottomleft", fill=cols, legend=leglabs(brks), bty="n")
title(main="Standardised mortality ratios for Auckland child deaths")
brks <- c(0,0.05,0.1,0.2,0.8,0.9,0.95,1)
cols <- cm.colors(7)
plot(auckland, col=cols[findInterval(res$pmap, brks, all.inside=TRUE)])
legend("bottomleft", fill=cols, legend=leglabs(brks), bty="n")
title(main="Poisson probabilities for Auckland child mortality")



