### Name: spautolm
### Title: Spatial conditional and simultaneous autoregression model
###   estimation
### Aliases: spautolm residuals.spautolm deviance.spautolm coef.spautolm
###   fitted.spautolm print.spautolm summary.spautolm LR1.spautolm
###   logLik.spautolm print.summary.spautolm
### Keywords: spatial

### ** Examples

example(NY_data)
lm0 <- lm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata)
summary(lm0)
lm0w <- lm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata, weights=POP8)
summary(lm0w)
esar0 <- errorsarlm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata,
 listw=listw_NY)
summary(esar0)
system.time(esar1f <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME,
 data=nydata, listw=listw_NY, family="SAR", method="full", verbose=TRUE))
summary(esar1f)
system.time(esar1M <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME,
 data=nydata, listw=listw_NY, family="SAR", method="Matrix", verbose=TRUE))
summary(esar1M)
## Not run: 
##D system.time(esar1M <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME,
##D  data=nydata, listw=listw_NY, family="SAR", method="Matrix", verbose=TRUE,
##D  super=FALSE))
##D summary(esar1M)
##D system.time(esar1M <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME,
##D  data=nydata, listw=listw_NY, family="SAR", method="Matrix", verbose=TRUE,
##D  super=FALSE, Matrix_intern=TRUE, find_interval=FALSE))
##D summary(esar1M)
##D system.time(esar1s <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME,
##D  data=nydata, listw=listw_NY, family="SAR", method="spam", verbose=TRUE))
##D summary(esar1s)
##D esar1wf <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata,
##D  listw=listw_NY, weights=POP8, family="SAR", method="full")
##D summary(esar1wf)
##D system.time(esar1wM <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME,
##D  data=nydata, listw=listw_NY, weights=POP8, family="SAR", method="Matrix"))
##D summary(esar1wM)
##D system.time(esar1wM <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME,
##D  data=nydata, listw=listw_NY, weights=POP8, family="SAR", method="Matrix",
##D  super=FALSE))
##D summary(esar1wM)
##D esar1ws <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata,
##D  listw=listw_NY, weights=POP8, family="SAR", method="spam")
##D summary(esar1ws)
##D ecar1f <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata,
##D  listw=listw_NY, family="CAR", method="full")
##D summary(ecar1f)
##D system.time(ecar1M <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME,
##D  data=nydata, listw=listw_NY, family="CAR", method="Matrix"))
##D summary(ecar1M)
##D system.time(ecar1M <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME,
##D  data=nydata, listw=listw_NY, family="CAR", method="Matrix", super=FALSE))
##D summary(ecar1M)
##D ecar1s <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata,
##D  listw=listw_NY, family="CAR", method="spam")
##D summary(ecar1s)
##D ecar1wf <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata,
##D  listw=listw_NY, weights=nydata$POP8, family="CAR", method="full")
##D summary(ecar1wf)
##D system.time(ecar1wM <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME,
##D  data=nydata, listw=listw_NY, weights=POP8, family="CAR", method="Matrix"))
##D summary(ecar1wM)
##D system.time(ecar1wM <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME,
##D  data=nydata, listw=listw_NY, weights=POP8, family="CAR", method="Matrix",
##D  super=FALSE))
##D summary(ecar1wM)
##D ecar1ws <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata,
##D  listw=listw_NY, weights=POP8, family="CAR", method="spam")
##D summary(ecar1ws)
##D example(nc.sids)
##D ft.SID74 <- sqrt(1000)*(sqrt(nc.sids$SID74/nc.sids$BIR74) + sqrt((nc.sids$SID74+1)/nc.sids$BIR74))
##D lm_nc <- lm(ft.SID74 ~ 1)
##D sids.nhbr30 <- dnearneigh(cbind(nc.sids$east, nc.sids$north), 0, 30, row.names=row.names(nc.sids))
##D sids.nhbr30.dist <- nbdists(sids.nhbr30, cbind(nc.sids$east, nc.sids$north))
##D sids.nhbr <- listw2sn(nb2listw(sids.nhbr30, glist=sids.nhbr30.dist, style="B", zero.policy=TRUE))
##D dij <- sids.nhbr[,3]
##D n <- nc.sids$BIR74
##D el1 <- min(dij)/dij
##D el2 <- sqrt(n[sids.nhbr$to]/n[sids.nhbr$from])
##D sids.nhbr$weights <- el1*el2
##D sids.nhbr.listw <- sn2listw(sids.nhbr)
##D both <- factor(paste(nc.sids$L_id, nc.sids$M_id, sep=":"))
##D ft.NWBIR74 <- sqrt(1000)*(sqrt(nc.sids$NWBIR74/nc.sids$BIR74) + sqrt((nc.sids$NWBIR74+1)/nc.sids$BIR74))
##D mdata <- data.frame(both, ft.NWBIR74, ft.SID74, BIR74=nc.sids$BIR74)
##D outl <- which.max(rstandard(lm_nc))
##D as.character(nc.sids$names[outl])
##D mdata.4 <- mdata[-outl,]
##D W <- listw2mat(sids.nhbr.listw)
##D W.4 <- W[-outl, -outl]
##D sids.nhbr.listw.4 <- mat2listw(W.4)
##D esarI <- errorsarlm(ft.SID74 ~ 1, data=mdata, listw=sids.nhbr.listw,
##D  zero.policy=TRUE)
##D summary(esarI)
##D esarIa <- spautolm(ft.SID74 ~ 1, data=mdata, listw=sids.nhbr.listw,
##D  family="SAR")
##D summary(esarIa)
##D esarIV <- errorsarlm(ft.SID74 ~ ft.NWBIR74, data=mdata, listw=sids.nhbr.listw,
##D  zero.policy=TRUE)
##D summary(esarIV)
##D esarIVa <- spautolm(ft.SID74 ~ ft.NWBIR74, data=mdata, listw=sids.nhbr.listw,
##D  family="SAR")
##D summary(esarIVa)
##D esarIaw <- spautolm(ft.SID74 ~ 1, data=mdata, listw=sids.nhbr.listw,
##D  weights=BIR74, family="SAR")
##D summary(esarIaw)
##D esarIIaw <- spautolm(ft.SID74 ~ both - 1, data=mdata, listw=sids.nhbr.listw,
##D  weights=BIR74, family="SAR")
##D summary(esarIIaw)
##D esarIVaw <- spautolm(ft.SID74 ~ ft.NWBIR74, data=mdata,
##D  listw=sids.nhbr.listw, weights=BIR74, family="SAR")
##D summary(esarIVaw)
##D ecarIaw <- spautolm(ft.SID74 ~ 1, data=mdata.4, listw=sids.nhbr.listw.4,
##D  weights=BIR74, family="CAR")
##D summary(ecarIaw)
##D ecarIIaw <- spautolm(ft.SID74 ~ both - 1, data=mdata.4,
##D  listw=sids.nhbr.listw.4, weights=BIR74, family="CAR")
##D summary(ecarIIaw)
##D ecarIVaw <- spautolm(ft.SID74 ~ ft.NWBIR74, data=mdata.4,
##D  listw=sids.nhbr.listw.4, weights=BIR74, family="CAR")
##D summary(ecarIVaw)
##D nc.sids$fitIV <- append(fitted.values(ecarIVaw), NA, outl-1)
##D spplot(nc.sids, c("fitIV"), cuts=12) # Cressie 1993, p. 565
##D data(oldcol)
##D COL.errW.eig <- errorsarlm(CRIME ~ INC + HOVAL, data=COL.OLD,
##D  nb2listw(COL.nb, style="W"))
##D summary(COL.errW.eig)
##D COL.errW.sar <- spautolm(CRIME ~ INC + HOVAL, data=COL.OLD,
##D  nb2listw(COL.nb, style="W"))
##D summary(COL.errW.sar)
##D data(boston)
##D gp1 <- spautolm(log(CMEDV) ~ CRIM + ZN + INDUS + CHAS + I(NOX^2)
##D  + I(RM^2) + AGE + log(DIS) + log(RAD) + TAX + PTRATIO + B + log(LSTAT), 
##D  data=boston.c, nb2listw(boston.soi), family="SMA")
##D summary(gp1)
## End(Not run)



