aple.plot               package:spdep               R Documentation

_A_p_p_r_o_x_i_m_a_t_e _p_r_o_f_i_l_e-_l_i_k_e_l_i_h_o_o_d _e_s_t_i_m_a_t_o_r (_A_P_L_E) _s_c_a_t_t_e_r_p_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     A scatterplot decomposition of the approximate profile-likelihood
     estimator, and a local APLE based on the list of vectors returned
     by the scatterplot function.

_U_s_a_g_e:

     aple.plot(x, listw, override_similarity_check=FALSE, do.plot=TRUE, ...)
     localAple(x, listw, override_similarity_check=FALSE)

_A_r_g_u_m_e_n_t_s:

       x: a zero-mean detrended continuous variable

   listw: a 'listw' object from for example 'nb2listw'

override\_similarity\_check: default FALSE, if TRUE - typically for
          row-standardised weights with asymmetric underlying general
          weights - similarity is not checked

 do.plot: default TRUE: should a scatterplot be drawn

     ...: other arguments to be passed to 'plot'

_D_e_t_a_i_l_s:

     The function solves a secondary eigenproblem of size n internally,
     so constructing the values for the scatterplot is quite compute
     and memory intensive, and is not suitable for very large n.

_V_a_l_u_e:

     'aple.plot' returns list with components: 

       X: A vector as described in Li et al. (2007), p. 366.

       Y: A vector as described in Li et al. (2007), p. 367.


     'localAple' returns a vector of local APLE values.

_A_u_t_h_o_r(_s):

     Roger Bivand Roger.Bivand@nhh.no

_R_e_f_e_r_e_n_c_e_s:

     Li, H, Calder, C. A. and Cressie N. A. C. (2007) Beyond Moran's I:
     testing for spatial dependence based on the spatial autoregressive
     model. Geographical Analysis 39, pp. 357-375.

_S_e_e _A_l_s_o:

     'aple'

_E_x_a_m_p_l_e_s:

     ## Not run: 
     example(aple)
     plt_out <- aple.plot(scale(wheat$yield_detrend, scale=FALSE),
      nb2listw(nbr12, style="W"), cex=0.6)
     crossprod(plt_out$Y, plt_out$X)/crossprod(plt_out$X)
     lm_obj <- lm(Y ~ X, plt_out)
     abline(lm_obj)
     abline(v=0, h=0, lty=2)
     zz <- summary(influence.measures(lm_obj))
     infl <- as.integer(rownames(zz))
     points(plt_out$X[infl], plt_out$Y[infl], pch=3, cex=0.6, col="red")
     wheat$localAple <- localAple(scale(wheat$yield_detrend, scale=FALSE),
      nb2listw(nbr12, style="W"))
     mean(wheat$localAple)
     hist(wheat$localAple)
     spl <- list("sp.text", coordinates(wheat)[infl,], rep("*", length(infl)))
     spplot(wheat, "localAple", sp.layout=spl)
     ## End(Not run)

