geary.mc                package:spdep                R Documentation

_P_e_r_m_u_t_a_t_i_o_n _t_e_s_t _f_o_r _G_e_a_r_y'_s _C _s_t_a_t_i_s_t_i_c

_D_e_s_c_r_i_p_t_i_o_n:

     A permutation test for Geary's C statistic calculated by using
     nsim random permutations of x for the given spatial weighting
     scheme, to establish the rank of the observed statistic in
     relation to the nsim simulated values.

_U_s_a_g_e:

     geary.mc(x, listw, nsim, zero.policy=FALSE, alternative="less",
      spChk=NULL, adjust.n=TRUE)

_A_r_g_u_m_e_n_t_s:

       x: a numeric vector the same length as the neighbours list in
          listw

   listw: a 'listw' object created for example by 'nb2listw'

    nsim: number of permutations

zero.policy: if TRUE assign zero to the lagged value of zones without
          neighbours, if FALSE assign NA

alternative: a character string specifying the alternative hypothesis,
          must be one of "less" (default), or "greater".

   spChk: should the data vector names be checked against the spatial
          objects for identity integrity, TRUE, or FALSE, default NULL
          to use 'get.spChkOption()'

adjust.n: default TRUE, if FALSE the number of observations is not
          adjusted for no-neighbour observations, if TRUE, the number
          of observations is adjusted

_V_a_l_u_e:

     A list with class 'htest' and 'mc.sim' containing the following
     components: 

statistic: the value of the observed Geary's C.

parameter: the rank of the observed Geary's C.

 p.value: the pseudo p-value of the test.

alternative: a character string describing the alternative hypothesis.

  method: a character string giving the method used.

data.name: a character string giving the name(s) of the data, and the
          number of simulations.

     res: nsim simulated values of statistic, final value is observed
          statistic

_A_u_t_h_o_r(_s):

     Roger Bivand Roger.Bivand@nhh.no

_R_e_f_e_r_e_n_c_e_s:

     Cliff, A. D., Ord, J. K. 1981 Spatial processes, Pion, p. 63-5.

_S_e_e _A_l_s_o:

     'geary', 'geary.test'

_E_x_a_m_p_l_e_s:

     data(oldcol)
     sim1 <- geary.mc(COL.OLD$CRIME, nb2listw(COL.nb, style="W"),
      nsim=99, alternative="less")
     sim1
     mean(sim1$res)
     var(sim1$res)
     summary(sim1$res)
     colold.lags <- nblag(COL.nb, 3)
     sim2 <- geary.mc(COL.OLD$CRIME, nb2listw(colold.lags[[2]],
      style="W"), nsim=99)
     sim2
     summary(sim2$res)
     sim3 <- geary.mc(COL.OLD$CRIME, nb2listw(colold.lags[[3]],
      style="W"), nsim=99)
     sim3
     summary(sim3$res)

