moran.mc            package:spdep            R Documentation(latin1)

_P_e_r_m_u_t_a_t_i_o_n _t_e_s_t _f_o_r _M_o_r_a_n'_s _I _s_t_a_t_i_s_t_i_c

_D_e_s_c_r_i_p_t_i_o_n:

     A permutation test for Moran's I statistic calculated by using
     nsim random permutations of x for the given spatial weighting
     scheme, to establish the rank of the observed statistic in
     relation to the nsim simulated values. The examples show how
     'boot(sim="permutation")' can replicate this function (thanks to
     Virgilio Gmez Rubio and the DCluster package).

_U_s_a_g_e:

     moran.mc(x, listw, nsim, zero.policy=FALSE, alternative="greater",
      na.action=na.fail, spChk=NULL)

_A_r_g_u_m_e_n_t_s:

       x: a numeric vector the same length as the neighbours list in
          listw

   listw: a 'listw' object created for example by 'nb2listw'

    nsim: number of permutations

zero.policy: if TRUE assign zero to the lagged value of zones without
          neighbours, if FALSE assign NA

alternative: a character string specifying the alternative hypothesis,
          must be one of "greater" (default), or "less".

na.action: a function (default 'na.fail'), can also be 'na.omit' or
          'na.exclude' - in these cases the weights list will be
          subsetted to remove NAs in the data. It may be necessary to
          set zero.policy to TRUE because this subsetting may create
          no-neighbour observations. Note that only weights lists
          created without using the glist argument to 'nb2listw' may be
          subsetted. 'na.pass' is not permitted because it is
          meaningless in a permutation test.

   spChk: should the data vector names be checked against the spatial
          objects for identity integrity, TRUE, or FALSE, default NULL
          to use 'get.spChkOption()'

_V_a_l_u_e:

     A list with class 'htest' and 'mc.sim' containing the following
     components: 

statistic: the value of the observed Moran's I.

parameter: the rank of the observed Moran's I.

 p.value: the pseudo p-value of the test.

alternative: a character string describing the alternative hypothesis.

  method: a character string giving the method used.

data.name: a character string giving the name(s) of the data, and the
          number of simulations.

     res: nsim simulated values of statistic, final value is observed
          statistic

_A_u_t_h_o_r(_s):

     Roger Bivand Roger.Bivand@nhh.no

_R_e_f_e_r_e_n_c_e_s:

     Cliff, A. D., Ord, J. K. 1981 Spatial processes, Pion, p. 63-5.

_S_e_e _A_l_s_o:

     'moran', 'moran.test'

_E_x_a_m_p_l_e_s:

     data(oldcol)
     colw <- nb2listw(COL.nb, style="W")
     nsim <- 99
     set.seed(1234)
     sim1 <- moran.mc(COL.OLD$CRIME, listw=colw, nsim=nsim)
     sim1
     mean(sim1$res[1:nsim])
     var(sim1$res[1:nsim])
     summary(sim1$res[1:nsim])
     MoranI.boot <- function(var, i, ...) {
     var <- var[i]
     return(moran(x=var, ...)$I)
     }
     set.seed(1234)
     library(boot)
     boot1 <- boot(COL.OLD$CRIME, statistic=MoranI.boot, R=nsim,
      sim="permutation", listw=colw, n=nrow(COL.OLD), S0=Szero(colw))
     boot1
     plot(boot1)
     mean(boot1$t)
     var(boot1$t)
     summary(boot1$t)
     colold.lags <- nblag(COL.nb, 3)
     set.seed(1234)
     sim2 <- moran.mc(COL.OLD$CRIME, nb2listw(colold.lags[[2]],
      style="W"), nsim=nsim)
     summary(sim2$res[1:nsim])
     sim3 <- moran.mc(COL.OLD$CRIME, nb2listw(colold.lags[[3]],
      style="W"), nsim=nsim)
     summary(sim3$res[1:nsim])

