moran.plot               package:spdep               R Documentation

_M_o_r_a_n _s_c_a_t_t_e_r_p_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     A plot of spatial data against its spatially lagged values,
     augmented by reporting the summary of influence measures for the
     linear relationship between the data and the lag. If zero policy
     is TRUE, such observations are also marked if they occur.

_U_s_a_g_e:

     moran.plot(x, listw, zero.policy=FALSE, spChk=NULL, labels=NULL,
      xlab=NULL, ylab=NULL, quiet=FALSE, ...)

_A_r_g_u_m_e_n_t_s:

       x: a numeric vector the same length as the neighbours list in
          listw

   listw: a 'listw' object created for example by 'nb2listw'

zero.policy: if TRUE assign zero to the lagged value of zones without
          neighbours, if FALSE assign NA

   spChk: should the data vector names be checked against the spatial
          objects for identity integrity, TRUE, or FALSE, default NULL
          to use 'get.spChkOption()'

  labels: character labels for points with high influence measures, if
          set to FALSE, no labels are plotted for points with large
          influence

    xlab: label for x axis

    ylab: label for x axis

   quiet: if TRUE, output of summary of influence object suppressed

     ...: further graphical parameters as in 'par(..)'

_V_a_l_u_e:

     The function returns an influence object from
     'influence.measures'.

_A_u_t_h_o_r(_s):

     Roger Bivand Roger.Bivand@nhh.no

_R_e_f_e_r_e_n_c_e_s:

     Anselin, L. 1996. The Moran scatterplot as an ESDA tool to assess
     local instability in spatial association. pp. 111-125 in M. M.
     Fischer, H. J. Scholten and D. Unwin (eds) Spatial analytical
     perspectives on GIS, London, Taylor and Francis; Anselin, L. 1995.
     Local indicators of spatial association, Geographical Analysis,
     27, 93-115

_S_e_e _A_l_s_o:

     'localmoran', 'summary.infl'

_E_x_a_m_p_l_e_s:

     data(afcon)
     moran.plot(afcon$totcon, nb2listw(paper.nb),
      labels=as.character(afcon$name), pch=19)
     moran.plot(scale(afcon$totcon), nb2listw(paper.nb),
      labels=as.character(afcon$name), xlim=c(-2, 4), ylim=c(-2,4), pch=19)

