### Name: gwr
### Title: Geographically weighted regression
### Aliases: gwr print.gwr
### Keywords: spatial

### ** Examples

data(columbus)
col.lm <- lm(crime ~ income + housing, data=columbus)
summary(col.lm)
col.bw <- gwr.sel(crime ~ income + housing, data=columbus,
  coords=cbind(columbus$x, columbus$y))
col.gauss <- gwr(crime ~ income + housing, data=columbus,
  coords=cbind(columbus$x, columbus$y), bandwidth=col.bw, hatmatrix=TRUE)
col.gauss
col.d <- gwr.sel(crime ~ income + housing, data=columbus,
  coords=cbind(columbus$x, columbus$y), gweight=gwr.bisquare)
col.bisq <- gwr(crime ~ income + housing, data=columbus,
  coords=cbind(columbus$x, columbus$y), bandwidth=col.d, 
  gweight=gwr.bisquare, hatmatrix=TRUE)
col.bisq
data(georgia)
g.adapt.gauss <- gwr.sel(PctBach ~ TotPop90 + PctRural + PctEld + PctFB + PctPov + PctBlack, data=gSRDF, adapt=TRUE)
res.adpt <- gwr(PctBach ~ TotPop90 + PctRural + PctEld + PctFB + PctPov + PctBlack, data=gSRDF, adapt=g.adapt.gauss)
res.adpt
pairs(as(res.adpt$SDF, "data.frame")[,2:8], pch=".")
brks <- c(-0.25, 0, 0.01, 0.025, 0.075)
cols <- grey(5:2/6)
plot(res.adpt$SDF, col=cols[findInterval(res.adpt$SDF$PctBlack, brks, all.inside=TRUE)])
data(meuse)
coordinates(meuse) <- c("x", "y")
meuse$ffreq <- factor(meuse$ffreq)
data(meuse.grid)
coordinates(meuse.grid) <- c("x", "y")
meuse.grid$ffreq <- factor(meuse.grid$ffreq)
gridded(meuse.grid) <- TRUE
xx <- gwr(cadmium ~ dist, meuse, bandwidth = 228, hatmatrix=TRUE)
xx
x <- gwr(cadmium ~ dist, meuse, bandwidth = 228, fit.points = meuse.grid, predict=TRUE, se.fit=TRUE, fittedGWRobject=xx)
x
library(lattice)
trellis.par.set(sp.theme())
spplot(x$SDF, "pred")
spplot(x$SDF, "pred.se")
## Not run: 
##D   g.bw.gauss <- gwr.sel(PctBach ~ TotPop90 + PctRural + PctEld + PctFB + PctPov + PctBlack, data=gSRDF)
##D   res.bw <- gwr(PctBach ~ TotPop90 + PctRural + PctEld + PctFB + PctPov + PctBlack, data=gSRDF, bandwidth=g.bw.gauss)
##D   res.bw
##D   pairs(as(res.bw$SDF, "data.frame")[,2:8], pch=".")
##D   plot(res.bw$SDF, col=cols[findInterval(res.bw$SDF$PctBlack, brks, all.inside=TRUE)])
##D   g.bw.gauss <- gwr.sel(PctBach ~ TotPop90 + PctRural + PctEld + PctFB + PctPov + PctBlack, data=gSRDF, longlat=TRUE)
##D   if (suppressWarnings(require(maptools)) &&
##D     suppressWarnings(require(gpclib))) {
##D     gSR <- as(gSRDF, "SpatialPolygons")
##D     length(slot(gSR, "polygons"))
##D     gSRouter <- unionSpatialPolygons(gSR, IDs=rep("Georgia", 159))
##D     SG <- GE_SpatialGrid(gSRouter, maxPixels = 100)
##D     SPxMASK0 <- overlay(gSRouter, SG$SG)
##D     SGDF <- SpatialGridDataFrame(slot(SG$SG, "grid"),
##D       data=data.frame(SPxMASK0=SPxMASK0),
##D       proj4string=CRS(proj4string(gSRouter)))
##D     SPxDF <- as(SGDF, "SpatialPixelsDataFrame")
##D     res.bw <- gwr(PctBach ~ TotPop90 + PctRural + PctEld + PctFB + PctPov +
##D       PctBlack, data=gSRDF, bandwidth=g.bw.gauss, fit.points=SPxDF,
##D       longlat=TRUE)
##D     res.bw
##D     spplot(res.bw$SDF, "PctBlack")
##D   }
## End(Not run)



