### Name: pchisqsum
### Title: Distribution of quadratic forms
### Aliases: pchisqsum
### Keywords: survey distribution

### ** Examples

x <- 5*rnorm(1001)^2+rnorm(1001)^2
x.thin<-sort(x)[1+(0:100)*10]
p.invert<-pchisqsum(x.thin,df=c(1,1),a=c(5,1),method="int" ,lower=FALSE)
p.satt<-pchisqsum(x.thin,df=c(1,1),a=c(5,1),method="satt",lower=FALSE)
p.sadd<-pchisqsum(x.thin,df=c(1,1),a=c(5,1),method="sad",lower=FALSE)

plot(p.invert, p.satt,type="l",log="xy")
abline(0,1,lty=2,col="purple")
plot(p.invert, p.sadd,type="l",log="xy")
abline(0,1,lty=2,col="purple")



