### Name: svyplot
### Title: Plots for survey data
### Aliases: svyplot svyplot.default
### Keywords: survey hplot

### ** Examples

data(api)
dstrat<-svydesign(id=~1,strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)

svyplot(api00~api99, design=dstrat, style="bubble")
svyplot(api00~api99, design=dstrat, style="transparent",pch=19)
## Not run: 
##D ## these two require the hexbin package from Bioconductor
##D svyplot(api00~api99, design=dstrat, style="hex", xlab="1999 API",ylab="2000 API")
##D svyplot(api00~api99, design=dstrat, style="grayhex",legend=0)
## End(Not run)

dclus2<-svydesign(id=~dnum+snum,  weights=~pw,
                    data=apiclus2, fpc=~fpc1+fpc2)
svyplot(api00~api99, design=dclus2, style="subsample")
svyplot(api00~api99, design=dclus2, style="subsample",
          amount=list(x=25,y=25))

svyplot(api00~api99, design=dstrat,
  basecol=function(df){c("goldenrod","tomato","sienna")[as.numeric(df$stype)]},
  style="transparent",pch=19,alpha=c(0,1))
legend("topleft",col=c("goldenrod","tomato","sienna"), pch=19, legend=c("E","H","M"))




