###################################################
### chunk number 1: 
###################################################
library(survey)
data(fpc)
dfpc<-svydesign(id=~psuid,strat=~stratid,weight=~weight,data=fpc,nest=TRUE)
dsub<-subset(dfpc,x>4)
svymean(~x,design=dsub)


###################################################
### chunk number 2: 
###################################################
svyby(~x,~I(x>4),design=dfpc, svymean)


###################################################
### chunk number 3: 
###################################################
summary(svyglm(x~I(x>4)+0,design=dfpc))


###################################################
### chunk number 4: 
###################################################
svyratio(~I(x*(x>4)),~as.numeric(x>4), dfpc)


###################################################
### chunk number 5: 
###################################################
data(api)
dclus1<-svydesign(id=~dnum, weights=~pw, data=apiclus1, fpc=~fpc)
pop.totals<-c(`(Intercept)`=6194, stypeH=755, stypeM=1018)
gclus1 <- calibrate(dclus1, ~stype+api99, c(pop.totals, api99=3914069))

svymean(~api00, subset(gclus1, comp.imp=="Yes"))
svyratio(~I(api00*(comp.imp=="Yes")), ~as.numeric(comp.imp=="Yes"), gclus1)
summary(svyglm(api00~comp.imp-1, gclus1))


###################################################
### chunk number 6: 
###################################################
data(mu284)
dmu284<-svydesign(id=~id1+id2,fpc=~n1+n2, data=mu284)

svymean(~y1, subset(dmu284,y1>40))
svyratio(~I(y1*(y1>40)),~as.numeric(y1>40),dmu284)
summary(svyglm(y1~I(y1>40)+0,dmu284))


###################################################
### chunk number 7: 
###################################################
library("survival")
data(nwtco)
nwtco$incc2<-as.logical(with(nwtco, ifelse(rel | instit==2,1,rbinom(nrow(nwtco),1,.1))))
dccs8<-twophase(id=list(~seqno,~seqno), strata=list(NULL,~interaction(rel,stage,instit)),
                data=nwtco, subset=~incc2)
svymean(~rel, subset(dccs8,age>36))
svyratio(~I(rel*as.numeric(age>36)), ~as.numeric(age>36), dccs8)
summary(svyglm(rel~I(age>36)+0, dccs8))


