### Name: objBrowse
### Title: Functions to implement an object browser
### Aliases: objBrowse objClear objDir objInfo objList objMenu objSearch
###   print.objList write.objList
### Keywords: misc

### ** Examples

# Create various context menus
data(iris)
(objInfo(object = "iris"))
data(trees)
# For one object
(objMenu(objects = "iris"))
# For multiple objects
(objMenu(objects = c("iris", "trees")))
# For inxistant object (return "")
(objInfo(object = "noobject"))
(objMenu(objects = "noobject"))
rm(iris, trees)

# For environments
(objInfo(envir = ".GlobalEnv"))
(objMenu(envir = ".GlobalEnv"))
(objInfo(envir = "TempEnv"))
(objMenu(envir = "TempEnv"))
(objInfo(envir = "package:datasets"))
(objMenu(envir = "package:datasets"))
# For an environment that does not exist on the search path (return "")
(objInfo(envir = "noenvir"))
(objMenu(envir = "noenvir"))



