### Name: progress
### Title: Display progression of a long calculation on the console and/or
###   in a GUI
### Aliases: progress
### Keywords: utilities

### ** Examples

# 1) A simple progress indicator in percent
for (i in 0:101) {
        progress(i)
        Sys.sleep(0.05)
        if (i == 101) cat("Done!\n")
}

# 2) A progress indicator with 'x on y'
for (i in 0:31) {
        progress(i, 30)
        Sys.sleep(0.2)
        if (i == 31) cat("Done!\n")
}

# 3) A progress bar in percent
for (i in 0:101) {
        progress(i, progress.bar = TRUE)
        Sys.sleep(0.05)
        if (i == 101) cat("Done!\n")
}

# 4) A progress indicator with 'x on y'
for (i in 0:21) {
        progress(i, 20, progress.bar = TRUE)
        Sys.sleep(0.2)
        if (i == 21) cat("Done!\n")
}

# 5) A progression dialog box with Tcl/Tk
## Not run: 
##D if (require(tcltk)) {
##D     guiProgress <- function(value, max.value) {
##D         # Do we need to destroy the progression dialog box?
##D         if (value > max.value) {
##D             try(tkdestroy(getTemp("guiProgressWindow")), silent = TRUE)
##D             # Clean temporary variables
##D             rmTemp(c("guiProgressState", "guiProgressWindow", "guiProgressCancel"))
##D             # ...and exit
##D             return(invisible(FALSE))
##D         } else if (existsTemp("guiProgressWindow") &&
##D             !inherits(try(tkwm.deiconify(tt <- getTemp("guiProgressWindow")),
##D                 silent = TRUE), "try-error")) {
##D             # The progression dialog box exists
##D             # Focus on it and change progress value
##D             tkfocus(tt)
##D             State <- getTemp("guiProgressState")
##D             tclvalue(State) <- value
##D         } else {
##D             # The progression dialog box must be (re)created
##D             # First, make sure there is no remaining "guiProgressStop"
##D             rmTemp("guiProgressCancel")
##D             # Create a Tcl variable to hold current progression state
##D             State <- tclVar(value)
##D             assignTemp("guiProgressState", State)
##D             # Create the progression dialog box
##D             tt <- tktoplevel()
##D             assignTemp("guiProgressWindow", tt)
##D             tktitle(tt) <- "Waiting..."
##D             sc <- tkscale(tt, orient = "h", state = "disabled", to = max.value,
##D                 label = "Progress (
##D             tkpack(sc)
##D             but <- tkbutton(tt, text = "Cancel", command = function() {
##D                 # Set a flag telling to stop running calculation
##D                 assignTemp("guiProgressCancel", TRUE) # Content is not important!
##D                 # Destroy the window
##D                 tkdestroy(tt)
##D             })
##D             tkpack(but)
##D         }
##D         return(invisible(TRUE))
##D     }
##D     #
##D     # Register it as function to use in progress()
##D     changeTemp(".progress", "guiProgress", guiProgress, replace.existing = FALSE)
##D     rm(guiProgress) # Don't need this any more
##D     #
##D     # Test it...
##D     for (i in 0:101) {
##D         progress(i) # Could also set console = FALSE for using the GUI only
##D         Sys.sleep(0.1)
##D         # The code to stop long calc when user presses "Cancel"
##D         if (existsTemp("guiProgressCancel")) {
##D             progress(101, console = FALSE) # Make sure to clean up everything
##D             break
##D         }
##D         if (i == 101) cat("Done!\n")
##D     }
##D     #
##D     # Unregister the GUI for progress
##D     changeTemp(".progress", "guiProgress", NULL)
##D }
## End(Not run)



