ur.pp              package:urca              R Documentation(latin1)

_P_h_i_l_l_i_p_s & _P_e_r_r_o_n _U_n_i_t _R_o_o_t _T_e_s_t

_D_e_s_c_r_i_p_t_i_o_n:

     Performs the Phillips & Perron unit root test. Beside the Z
     statistics Z-alpha and Z-tau, the Z statistics for the
     deterministic part of the test regression are computed, too.

_U_s_a_g_e:

     ur.pp(x, type = c("Z-alpha", "Z-tau"), model = c("constant", "trend"),
           lags = c("short", "long"), use.lag = NULL)

_A_r_g_u_m_e_n_t_s:

       x: Vector to be tested for a unit root.

    type: Test type, either '"Z-alpha"' or '"Z-tau"'.

   model: Determines the deterministic part in the test regression.

    lags: Lags used for correction of error term.

 use.lag: Use of a different lag number, specified by the user.

_D_e_t_a_i_l_s:

     The function 'ur.pp()' computes the Phillips & Perron test. For
     correction of the error term a Bartlett window is used.

_V_a_l_u_e:

     An object of class 'ur.pp'.

_A_u_t_h_o_r(_s):

     Bernhard Pfaff

_R_e_f_e_r_e_n_c_e_s:

     Phillips, P.C.B. and Perron, P. (1988), Testing for a unit root in
     time series regression, _Biometrika_,  *75(2)*, 335-346.

     MacKinnon, J.G. (1991), Critical Values for Cointegration Tests,
     _Long-Run Economic Relationships_, eds. R.F. Engle and C.W.J.
     Granger, London, Oxford, 267-276.

     Download possible at: <URL: http://cowles.econ.yale.edu/>, see
     rubric 'Discussion Papers (CFDPs)' and <URL:
     http://www.econ.ucsd.edu/papers/files/90-4.pdf>.

_S_e_e _A_l_s_o:

     'ur.pp-class'.

_E_x_a_m_p_l_e_s:

     data(nporg)
     gnp <- na.omit(nporg[, "gnp.r"])
     pp.gnp <- ur.pp(gnp, type="Z-tau", model="trend", lags="short")
     summary(pp.gnp)

