ur.sp              package:urca              R Documentation(latin1)

_S_c_h_m_i_d_t & _P_h_i_l_l_i_p_s _U_n_i_t _R_o_o_t _T_e_s_t

_D_e_s_c_r_i_p_t_i_o_n:

     Performs the Schmidt & Phillips unit root test, where under the
     Null and Alternative Hypothesis the coefficients of the
     deterministic variables are included.

_U_s_a_g_e:

     ur.sp(y, type = c("tau", "rho"), pol.deg = c(1, 2, 3, 4),
           signif = c(0.01, 0.05, 0.1))

_A_r_g_u_m_e_n_t_s:

       y: Vector to be tested for a unit root.

    type: Test type, either 'tau' or 'rho' test.

 pol.deg: Degree of polynomial in the test regression.

  signif: Significance level for the critical value of the test
          statistic.

_D_e_t_a_i_l_s:

     Under the Null and the Alternative hypothesis the coefficients of
     the deterministic part of the test regression are included. Two
     test types are available: the 'rho'-test and the 'tau'-test. Both
     test are extracted from the LM principle.

_V_a_l_u_e:

     An object of class '"ur.sp"'.

_A_u_t_h_o_r(_s):

     Bernhard Pfaff

_R_e_f_e_r_e_n_c_e_s:

     Schmidt, P. and Phillips, P.C.B. (1992), LM Test for a Unit Root
     in the Presence of Deterministic Trends, _Oxford Bulletin of
     Economics and Statistics_, *54(3)*, 257-287.

     Download possible at: <URL: http://cowles.econ.yale.edu/>, see
     rubric 'Discussion Papers (CFDPs)'.

_S_e_e _A_l_s_o:

     'ur.sp-class'

_E_x_a_m_p_l_e_s:

     data(nporg)
     gnp <- na.omit(nporg[, "gnp.r"])
     sp.gnp <- ur.sp(gnp, type="tau", pol.deg=1, signif=0.01)
     summary(sp.gnp)

