/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.options.ClassOption;
import moa.options.FloatOption;
import moa.options.MultiChoiceOption;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DACC
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption learnerOption = new ClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "bayes.NaiveBayes");
    public FloatOption memberCountOption = new FloatOption("ensembleSize", 'n', "The maximum number of classifiers in an ensemble.", 20.0, 1.0, 2.147483647E9);
    public FloatOption maturityOption = new FloatOption("maturity", 'a', "The maturity age.", 20.0, 0.0, 100.0);
    public FloatOption evaluationSizeOption = new FloatOption("evalSize", 'e', "The size of the evaluation window.", 20.0, 1.0, 1000.0);
    public MultiChoiceOption combinationOption = new MultiChoiceOption("cmb", 'c', "The combination function.", new String[]{"MAX", "WVD"}, new String[]{"Maximum", "Weighted Vote of the best"}, 0);
    protected Classifier[] ensemble;
    protected Pair[] ensembleWeights;
    protected double[] ensembleAges;
    protected int[][] ensembleWindows;
    protected int nbInstances = 0;

    @Override
    public String getPurposeString() {
        return "Dynamic Adaptation to Concept Changes for data streams.";
    }

    protected void initVariables() {
        int ensembleSize = (int)this.memberCountOption.getValue();
        this.ensemble = new Classifier[ensembleSize];
        this.ensembleAges = new double[ensembleSize];
        this.ensembleWindows = new int[ensembleSize][(int)this.evaluationSizeOption.getValue()];
    }

    @Override
    public void resetLearningImpl() {
        Classifier learner = (Classifier)this.getPreparedClassOption(this.learnerOption);
        learner.resetLearning();
        this.initVariables();
        this.ensembleWeights = new Pair[this.ensemble.length];
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i] = learner.copy();
            this.ensembleAges[i] = 0.0;
            this.ensembleWeights[i] = new Pair(0.0, i);
            this.ensembleWindows[i] = new int[(int)this.evaluationSizeOption.getValue()];
        }
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        this.trainAndClassify(inst);
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        DoubleVector combinedVote = new DoubleVector();
        int cmb = this.combinationOption.getChosenIndex();
        ArrayList<Integer> arr = cmb == 0 ? this.getMAXIndexes() : this.getWVDIndexes();
        if (this.trainingWeightSeenByModel > 0.0) {
            for (int i = 0; i < arr.size(); ++i) {
                DoubleVector vote;
                if (!(this.ensembleWeights[arr.get((int)i).intValue()].val > 0.0) || !((vote = new DoubleVector(this.ensemble[arr.get(i)].getVotesForInstance(inst))).sumOfValues() > 0.0)) continue;
                vote.normalize();
                vote.scaleValues(this.ensembleWeights[arr.get((int)i).intValue()].val);
                combinedVote.addValues(vote);
            }
        }
        return combinedVote.getArrayRef();
    }

    protected void trainAndClassify(Instance inst) {
        Pair[] learners;
        int i;
        ++this.nbInstances;
        boolean mature = true;
        boolean unmature = true;
        for (i = 0; i < this.getNbActiveClassifiers(); ++i) {
            double sum;
            if (this.ensembleAges[i] < this.maturityOption.getValue() && i < this.getNbAdaptiveClassifiers()) {
                mature = false;
            }
            if (this.ensembleAges[i] >= this.maturityOption.getValue() && i < this.getNbAdaptiveClassifiers()) {
                unmature = false;
            }
            if (this.nbInstances < this.ensembleWeights[i].index + 1) continue;
            if (i < this.getNbAdaptiveClassifiers()) {
                this.ensemble[i].trainOnInstance(inst);
            }
            int val = this.ensemble[i].correctlyClassifies(inst) ? 1 : 0;
            this.ensembleWeights[i].val = sum = this.updateEvaluationWindow(i, val);
            this.ensembleAges[i] = this.ensembleAges[i] + 1.0;
        }
        if (unmature) {
            for (i = 0; i < this.getNbAdaptiveClassifiers(); ++i) {
                this.ensembleWeights[i].val = 1.0;
            }
        }
        if (mature && (learners = this.getHalf(false)).length > 0) {
            double rand = this.classifierRandom.nextInt(learners.length);
            this.discardModel(learners[(int)rand].index);
        }
    }

    public void discardModel(int index) {
        this.ensemble[index].resetLearning();
        this.ensembleWeights[index].val = 0.0;
        this.ensembleAges[index] = 0.0;
        this.ensembleWindows[index] = new int[(int)this.evaluationSizeOption.getValue()];
    }

    protected double updateEvaluationWindow(int index, int val) {
        int[] newEnsembleWindows = new int[this.ensembleWindows[index].length];
        int wsize = (int)Math.min(this.evaluationSizeOption.getValue(), this.ensembleAges[index] + 1.0);
        int sum = 0;
        for (int i = 0; i < wsize - 1; ++i) {
            newEnsembleWindows[i + 1] = this.ensembleWindows[index][i];
            sum += this.ensembleWindows[index][i];
        }
        newEnsembleWindows[0] = val;
        this.ensembleWindows[index] = newEnsembleWindows;
        if (this.ensembleAges[index] >= this.maturityOption.getValue()) {
            return (double)(sum + val) * 1.0 / (double)wsize;
        }
        return 0.0;
    }

    protected Pair[] getHalf(boolean bestHalf) {
        Object[] newEnsembleWeights = new Pair[this.getNbAdaptiveClassifiers()];
        System.arraycopy(this.ensembleWeights, 0, newEnsembleWeights, 0, newEnsembleWeights.length);
        if (bestHalf) {
            Arrays.sort(newEnsembleWeights, Collections.reverseOrder());
        } else {
            Arrays.sort(newEnsembleWeights);
        }
        Pair[] result = new Pair[(int)Math.floor(newEnsembleWeights.length / 2)];
        System.arraycopy(newEnsembleWeights, 0, result, 0, result.length);
        return result;
    }

    protected ArrayList<Integer> getMAXIndexes() {
        ArrayList<Integer> maxWIndex = new ArrayList<Integer>();
        Object[] newEnsembleWeights = new Pair[this.getNbActiveClassifiers()];
        System.arraycopy(this.ensembleWeights, 0, newEnsembleWeights, 0, newEnsembleWeights.length);
        Arrays.sort(newEnsembleWeights);
        double maxWVal = ((Pair)newEnsembleWeights[newEnsembleWeights.length - 1]).val;
        for (int i = newEnsembleWeights.length - 1; i >= 0 && ((Pair)newEnsembleWeights[i]).val == maxWVal; --i) {
            maxWIndex.add(((Pair)newEnsembleWeights[i]).index);
        }
        return maxWIndex;
    }

    protected ArrayList<Integer> getWVDIndexes() {
        ArrayList<Integer> maxWIndex = new ArrayList<Integer>();
        Object[] newEnsembleWeights = new Pair[this.getNbActiveClassifiers()];
        System.arraycopy(this.ensembleWeights, 0, newEnsembleWeights, 0, newEnsembleWeights.length);
        Arrays.sort(newEnsembleWeights);
        double minWVal = ((Pair)newEnsembleWeights[0]).val;
        double maxWVal = ((Pair)newEnsembleWeights[newEnsembleWeights.length - 1]).val;
        double med = (maxWVal - minWVal) * 1.0 / 2.0;
        for (int i = newEnsembleWeights.length - 1; i >= 0 && !(((Pair)newEnsembleWeights[i]).val < med); --i) {
            maxWIndex.add(((Pair)newEnsembleWeights[i]).index);
        }
        return maxWIndex;
    }

    protected int getNbActiveClassifiers() {
        return this.ensemble.length;
    }

    protected int getNbAdaptiveClassifiers() {
        return this.ensemble.length;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        Measurement[] measurements = new Measurement[]{new Measurement("size ", this.ensemble.length), new Measurement("maturity ", this.maturityOption.getValue()), new Measurement("evalsize ", this.evaluationSizeOption.getValue()), new Measurement("cmb ", this.combinationOption.getChosenIndex())};
        return measurements;
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public Classifier[] getSubClassifiers() {
        return (Classifier[])this.ensemble.clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Pair
    implements Comparable<Pair>,
    Serializable {
        private static final long serialVersionUID = 1L;
        double val;
        int index;

        public Pair(double d, int i) {
            this.val = d;
            this.index = i;
        }

        @Override
        public int compareTo(Pair other) {
            if (this.val - other.val > 0.0) {
                return 1;
            }
            if (this.val == other.val) {
                return 0;
            }
            return -1;
        }

        public double getValue() {
            return this.val;
        }
    }
}

