/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.driftdetection;

import moa.classifiers.rules.driftdetection.PageHinkleyTest;

public class PageHinkleyFading
extends PageHinkleyTest {
    private static final long serialVersionUID = 7110953184708812339L;
    private double fadingFactor = 0.99;
    protected double instancesSeen;

    public PageHinkleyFading(double threshold, double alpha) {
        super(threshold, alpha);
    }

    public void reset() {
        super.reset();
        this.instancesSeen = 0.0;
    }

    public boolean update(double error) {
        this.instancesSeen = 1.0 + this.fadingFactor * this.instancesSeen;
        double absolutError = Math.abs(error);
        this.sumAbsolutError = this.fadingFactor * this.sumAbsolutError + absolutError;
        if (this.instancesSeen > 30.0) {
            double mT = absolutError - this.sumAbsolutError / this.instancesSeen - this.alpha;
            this.cumulativeSum += mT;
            if (this.cumulativeSum < this.minimumValue) {
                this.minimumValue = this.cumulativeSum;
            }
            return this.cumulativeSum - this.minimumValue > this.threshold;
        }
        return false;
    }
}

