/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.appstream.model.Fleet;
import com.amazonaws.services.appstream.model.FleetError;
import com.amazonaws.services.appstream.model.transform.ComputeCapacityStatusJsonMarshaller;
import com.amazonaws.services.appstream.model.transform.FleetErrorJsonMarshaller;
import com.amazonaws.services.appstream.model.transform.VpcConfigJsonMarshaller;
import java.util.List;

public class FleetJsonMarshaller {
    private static FleetJsonMarshaller instance;

    public void marshall(Fleet fleet, StructuredJsonGenerator jsonGenerator) {
        if (fleet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<FleetError> fleetErrorsList;
            jsonGenerator.writeStartObject();
            if (fleet.getArn() != null) {
                jsonGenerator.writeFieldName("Arn").writeValue(fleet.getArn());
            }
            if (fleet.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(fleet.getName());
            }
            if (fleet.getDisplayName() != null) {
                jsonGenerator.writeFieldName("DisplayName").writeValue(fleet.getDisplayName());
            }
            if (fleet.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(fleet.getDescription());
            }
            if (fleet.getImageName() != null) {
                jsonGenerator.writeFieldName("ImageName").writeValue(fleet.getImageName());
            }
            if (fleet.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(fleet.getInstanceType());
            }
            if (fleet.getComputeCapacityStatus() != null) {
                jsonGenerator.writeFieldName("ComputeCapacityStatus");
                ComputeCapacityStatusJsonMarshaller.getInstance().marshall(fleet.getComputeCapacityStatus(), jsonGenerator);
            }
            if (fleet.getMaxUserDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("MaxUserDurationInSeconds").writeValue(fleet.getMaxUserDurationInSeconds().intValue());
            }
            if (fleet.getDisconnectTimeoutInSeconds() != null) {
                jsonGenerator.writeFieldName("DisconnectTimeoutInSeconds").writeValue(fleet.getDisconnectTimeoutInSeconds().intValue());
            }
            if (fleet.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(fleet.getState());
            }
            if (fleet.getVpcConfig() != null) {
                jsonGenerator.writeFieldName("VpcConfig");
                VpcConfigJsonMarshaller.getInstance().marshall(fleet.getVpcConfig(), jsonGenerator);
            }
            if (fleet.getCreatedTime() != null) {
                jsonGenerator.writeFieldName("CreatedTime").writeValue(fleet.getCreatedTime());
            }
            if ((fleetErrorsList = fleet.getFleetErrors()) != null) {
                jsonGenerator.writeFieldName("FleetErrors");
                jsonGenerator.writeStartArray();
                for (FleetError fleetErrorsListValue : fleetErrorsList) {
                    if (fleetErrorsListValue == null) continue;
                    FleetErrorJsonMarshaller.getInstance().marshall(fleetErrorsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FleetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FleetJsonMarshaller();
        }
        return instance;
    }
}

