/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticfilesystem.model.ModifyMountTargetSecurityGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ModifyMountTargetSecurityGroupsRequestMarshaller
implements Marshaller<Request<ModifyMountTargetSecurityGroupsRequest>, ModifyMountTargetSecurityGroupsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ModifyMountTargetSecurityGroupsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ModifyMountTargetSecurityGroupsRequest> marshall(ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest) {
        if (modifyMountTargetSecurityGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyMountTargetSecurityGroupsRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2015-02-01/mount-targets/{MountTargetId}/security-groups";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "MountTargetId", modifyMountTargetSecurityGroupsRequest.getMountTargetId());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList securityGroupsList = (SdkInternalList)modifyMountTargetSecurityGroupsRequest.getSecurityGroups();
            if (!securityGroupsList.isEmpty() || !securityGroupsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SecurityGroups");
                jsonGenerator.writeStartArray();
                for (String securityGroupsListValue : securityGroupsList) {
                    if (securityGroupsListValue == null) continue;
                    jsonGenerator.writeValue(securityGroupsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

