/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.Landmark;

public class LandmarkJsonMarshaller {
    private static LandmarkJsonMarshaller instance;

    public void marshall(Landmark landmark, StructuredJsonGenerator jsonGenerator) {
        if (landmark == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (landmark.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(landmark.getType());
            }
            if (landmark.getX() != null) {
                jsonGenerator.writeFieldName("X").writeValue(landmark.getX().floatValue());
            }
            if (landmark.getY() != null) {
                jsonGenerator.writeFieldName("Y").writeValue(landmark.getY().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LandmarkJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LandmarkJsonMarshaller();
        }
        return instance;
    }
}

