/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Protocol;
import com.amazonaws.Request;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.SdkHttpUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Date;

abstract class PresignRequestHandler<T extends AmazonWebServiceRequest>
extends RequestHandler2 {
    private static final String SERVICE_NAME = "rds";
    private static final String PARAM_SOURCE_REGION = "SourceRegion";
    private static final String PARAM_DESTINATION_REGION = "DestinationRegion";
    private static final String PARAM_PRESIGNED_URL = "PreSignedUrl";
    private final Class<T> requestClassToPreSign;
    private final Date signingOverrideDate;

    protected PresignRequestHandler(Class<T> requestClassToPreSign) {
        this(requestClassToPreSign, null);
    }

    protected PresignRequestHandler(Class<T> requestClassToPreSign, Date signingOverrideDate) {
        this.requestClassToPreSign = requestClassToPreSign;
        this.signingOverrideDate = signingOverrideDate != null ? new Date(signingOverrideDate.getTime()) : null;
    }

    public void beforeRequest(Request<?> request) {
        if (!this.requestClassToPreSign.isInstance(request.getOriginalRequest())) {
            return;
        }
        if (request.getParameters().containsKey(PARAM_PRESIGNED_URL)) {
            return;
        }
        PresignableRequest presignableRequest = this.adaptRequest((AmazonWebServiceRequest)this.requestClassToPreSign.cast(request.getOriginalRequest()));
        String sourceRegion = presignableRequest.getSourceRegion();
        if (sourceRegion == null) {
            return;
        }
        String destinationRegion = AwsHostNameUtils.parseRegion((String)request.getEndpoint().getHost(), (String)SERVICE_NAME);
        Request<?> requestToPresign = presignableRequest.marshall();
        requestToPresign.getParameters().remove(PARAM_SOURCE_REGION);
        requestToPresign.getParameters().put(PARAM_DESTINATION_REGION, Arrays.asList(destinationRegion));
        requestToPresign.setEndpoint(this.createEndpoint(sourceRegion, SERVICE_NAME));
        requestToPresign.setHttpMethod(HttpMethodName.GET);
        AWSCredentials credentials = (AWSCredentials)request.getHandlerContext(HandlerContextKey.AWS_CREDENTIALS);
        requestToPresign = this.presignRequest(requestToPresign, credentials, sourceRegion);
        String presignedUrl = this.generateUrl(requestToPresign);
        presignableRequest.setPreSignedUrl(presignedUrl);
        request.addParameter(PARAM_PRESIGNED_URL, presignedUrl);
        request.getParameters().remove(PARAM_SOURCE_REGION);
    }

    protected abstract PresignableRequest adaptRequest(T var1);

    private Request<?> presignRequest(Request<?> request, AWSCredentials credentials, String signingRegion) {
        AWS4Signer signer = this.createNewSignerWithRegion(signingRegion);
        signer.presignRequest(request, credentials, null);
        return request;
    }

    private AWS4Signer createNewSignerWithRegion(String signingRegion) {
        AWS4Signer signer = new AWS4Signer(true);
        signer.setRegionName(signingRegion);
        signer.setServiceName(SERVICE_NAME);
        signer.setOverrideDate(this.signingOverrideDate);
        return signer;
    }

    private URI createEndpoint(String regionName, String serviceName) {
        Region region = RegionUtils.getRegion((String)regionName);
        if (region == null) {
            throw new AmazonClientException("{" + serviceName + ", " + regionName + "} was not found in region metadata. Update to latest version of SDK and try again.");
        }
        return PresignRequestHandler.toURI(region.getServiceEndpoint(serviceName));
    }

    private String generateUrl(Request<?> request) {
        URI endpoint = request.getEndpoint();
        String uri = SdkHttpUtils.appendUri((String)endpoint.toString(), (String)request.getResourcePath(), (boolean)true);
        String encodedParams = SdkHttpUtils.encodeParameters(request);
        if (encodedParams != null && !encodedParams.isEmpty()) {
            uri = uri + "?" + encodedParams;
        }
        return uri;
    }

    private static URI toURI(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = Protocol.HTTPS + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected static interface PresignableRequest {
        public void setPreSignedUrl(String var1);

        public String getPreSignedUrl();

        public String getSourceRegion();

        public Request<?> marshall();
    }
}

