/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.Tag;
import com.amazonaws.services.servicecatalog.model.UpdateProductRequest;
import com.amazonaws.services.servicecatalog.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateProductRequestMarshaller
implements Marshaller<Request<UpdateProductRequest>, UpdateProductRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateProductRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateProductRequest> marshall(UpdateProductRequest updateProductRequest) {
        if (updateProductRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateProductRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.UpdateProduct");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> removeTagsList;
            List<Tag> addTagsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateProductRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(updateProductRequest.getAcceptLanguage());
            }
            if (updateProductRequest.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(updateProductRequest.getId());
            }
            if (updateProductRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updateProductRequest.getName());
            }
            if (updateProductRequest.getOwner() != null) {
                jsonGenerator.writeFieldName("Owner").writeValue(updateProductRequest.getOwner());
            }
            if (updateProductRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updateProductRequest.getDescription());
            }
            if (updateProductRequest.getDistributor() != null) {
                jsonGenerator.writeFieldName("Distributor").writeValue(updateProductRequest.getDistributor());
            }
            if (updateProductRequest.getSupportDescription() != null) {
                jsonGenerator.writeFieldName("SupportDescription").writeValue(updateProductRequest.getSupportDescription());
            }
            if (updateProductRequest.getSupportEmail() != null) {
                jsonGenerator.writeFieldName("SupportEmail").writeValue(updateProductRequest.getSupportEmail());
            }
            if (updateProductRequest.getSupportUrl() != null) {
                jsonGenerator.writeFieldName("SupportUrl").writeValue(updateProductRequest.getSupportUrl());
            }
            if ((addTagsList = updateProductRequest.getAddTags()) != null) {
                jsonGenerator.writeFieldName("AddTags");
                jsonGenerator.writeStartArray();
                for (Tag tag : addTagsList) {
                    if (tag == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tag, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((removeTagsList = updateProductRequest.getRemoveTags()) != null) {
                jsonGenerator.writeFieldName("RemoveTags");
                jsonGenerator.writeStartArray();
                for (String removeTagsListValue : removeTagsList) {
                    if (removeTagsListValue == null) continue;
                    jsonGenerator.writeValue(removeTagsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

