/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.AvailabilityZone;
import com.amazonaws.services.lightsail.model.Region;
import com.amazonaws.services.lightsail.model.transform.AvailabilityZoneJsonMarshaller;
import java.util.List;

public class RegionJsonMarshaller {
    private static RegionJsonMarshaller instance;

    public void marshall(Region region, StructuredJsonGenerator jsonGenerator) {
        if (region == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AvailabilityZone> availabilityZonesList;
            jsonGenerator.writeStartObject();
            if (region.getContinentCode() != null) {
                jsonGenerator.writeFieldName("continentCode").writeValue(region.getContinentCode());
            }
            if (region.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(region.getDescription());
            }
            if (region.getDisplayName() != null) {
                jsonGenerator.writeFieldName("displayName").writeValue(region.getDisplayName());
            }
            if (region.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(region.getName());
            }
            if ((availabilityZonesList = region.getAvailabilityZones()) != null) {
                jsonGenerator.writeFieldName("availabilityZones");
                jsonGenerator.writeStartArray();
                for (AvailabilityZone availabilityZonesListValue : availabilityZonesList) {
                    if (availabilityZonesListValue == null) continue;
                    AvailabilityZoneJsonMarshaller.getInstance().marshall(availabilityZonesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RegionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RegionJsonMarshaller();
        }
        return instance;
    }
}

