/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.CreateGameSessionRequest;
import com.amazonaws.services.gamelift.model.GameProperty;
import com.amazonaws.services.gamelift.model.transform.GamePropertyJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateGameSessionRequestMarshaller
implements Marshaller<Request<CreateGameSessionRequest>, CreateGameSessionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateGameSessionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateGameSessionRequest> marshall(CreateGameSessionRequest createGameSessionRequest) {
        if (createGameSessionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createGameSessionRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreateGameSession");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<GameProperty> gamePropertiesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createGameSessionRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(createGameSessionRequest.getFleetId());
            }
            if (createGameSessionRequest.getAliasId() != null) {
                jsonGenerator.writeFieldName("AliasId").writeValue(createGameSessionRequest.getAliasId());
            }
            if (createGameSessionRequest.getMaximumPlayerSessionCount() != null) {
                jsonGenerator.writeFieldName("MaximumPlayerSessionCount").writeValue(createGameSessionRequest.getMaximumPlayerSessionCount().intValue());
            }
            if (createGameSessionRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createGameSessionRequest.getName());
            }
            if ((gamePropertiesList = createGameSessionRequest.getGameProperties()) != null) {
                jsonGenerator.writeFieldName("GameProperties");
                jsonGenerator.writeStartArray();
                for (GameProperty gamePropertiesListValue : gamePropertiesList) {
                    if (gamePropertiesListValue == null) continue;
                    GamePropertyJsonMarshaller.getInstance().marshall(gamePropertiesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createGameSessionRequest.getCreatorId() != null) {
                jsonGenerator.writeFieldName("CreatorId").writeValue(createGameSessionRequest.getCreatorId());
            }
            if (createGameSessionRequest.getGameSessionId() != null) {
                jsonGenerator.writeFieldName("GameSessionId").writeValue(createGameSessionRequest.getGameSessionId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

