/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.SplitShardRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SplitShardRequestMarshaller
implements Marshaller<Request<SplitShardRequest>, SplitShardRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public SplitShardRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SplitShardRequest> marshall(SplitShardRequest splitShardRequest) {
        if (splitShardRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)splitShardRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.SplitShard");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (splitShardRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(splitShardRequest.getStreamName());
            }
            if (splitShardRequest.getShardToSplit() != null) {
                jsonGenerator.writeFieldName("ShardToSplit").writeValue(splitShardRequest.getShardToSplit());
            }
            if (splitShardRequest.getNewStartingHashKey() != null) {
                jsonGenerator.writeFieldName("NewStartingHashKey").writeValue(splitShardRequest.getNewStartingHashKey());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

