/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.OutputUpdate;
import com.amazonaws.services.kinesisanalytics.model.transform.DestinationSchemaJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisFirehoseOutputUpdateJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisStreamsOutputUpdateJsonMarshaller;

public class OutputUpdateJsonMarshaller {
    private static OutputUpdateJsonMarshaller instance;

    public void marshall(OutputUpdate outputUpdate, StructuredJsonGenerator jsonGenerator) {
        if (outputUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (outputUpdate.getOutputId() != null) {
                jsonGenerator.writeFieldName("OutputId").writeValue(outputUpdate.getOutputId());
            }
            if (outputUpdate.getNameUpdate() != null) {
                jsonGenerator.writeFieldName("NameUpdate").writeValue(outputUpdate.getNameUpdate());
            }
            if (outputUpdate.getKinesisStreamsOutputUpdate() != null) {
                jsonGenerator.writeFieldName("KinesisStreamsOutputUpdate");
                KinesisStreamsOutputUpdateJsonMarshaller.getInstance().marshall(outputUpdate.getKinesisStreamsOutputUpdate(), jsonGenerator);
            }
            if (outputUpdate.getKinesisFirehoseOutputUpdate() != null) {
                jsonGenerator.writeFieldName("KinesisFirehoseOutputUpdate");
                KinesisFirehoseOutputUpdateJsonMarshaller.getInstance().marshall(outputUpdate.getKinesisFirehoseOutputUpdate(), jsonGenerator);
            }
            if (outputUpdate.getDestinationSchemaUpdate() != null) {
                jsonGenerator.writeFieldName("DestinationSchemaUpdate");
                DestinationSchemaJsonMarshaller.getInstance().marshall(outputUpdate.getDestinationSchemaUpdate(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static OutputUpdateJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new OutputUpdateJsonMarshaller();
        }
        return instance;
    }
}

