/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.RecordFormat;
import com.amazonaws.services.kinesisanalytics.model.transform.MappingParametersJsonMarshaller;

public class RecordFormatJsonMarshaller {
    private static RecordFormatJsonMarshaller instance;

    public void marshall(RecordFormat recordFormat, StructuredJsonGenerator jsonGenerator) {
        if (recordFormat == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (recordFormat.getRecordFormatType() != null) {
                jsonGenerator.writeFieldName("RecordFormatType").writeValue(recordFormat.getRecordFormatType());
            }
            if (recordFormat.getMappingParameters() != null) {
                jsonGenerator.writeFieldName("MappingParameters");
                MappingParametersJsonMarshaller.getInstance().marshall(recordFormat.getMappingParameters(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecordFormatJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecordFormatJsonMarshaller();
        }
        return instance;
    }
}

